/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ncs.northbounder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.opennms.core.utils.EmptyKeyRelaxedTrustProvider;
import org.opennms.core.utils.HttpResponseRange;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.alarmd.api.NorthbounderException;
import org.opennms.netmgt.alarmd.api.support.AbstractNorthbounder;
import org.opennms.netmgt.ncs.northbounder.NCSNorthbounderConfig;
import org.opennms.netmgt.ncs.northbounder.transfer.ServiceAlarm;
import org.opennms.netmgt.ncs.northbounder.transfer.ServiceAlarmNotification;

public class NCSNorthbounder
extends AbstractNorthbounder {
    private static final String COMPONENT_NAME = "componentName";
    private static final String COMPONENT_FOREIGN_ID = "componentForeignId";
    private static final String COMPONENT_FOREIGN_SOURCE = "componentForeignSource";
    private static final String COMPONENT_TYPE = "componentType";
    private NCSNorthbounderConfig m_config;
    private JAXBContext m_context = JAXBContext.newInstance((Class[])new Class[]{ServiceAlarmNotification.class});
    private Marshaller m_marshaller = this.m_context.createMarshaller();

    public NCSNorthbounder(NCSNorthbounderConfig config) throws JAXBException {
        super("NCSNorthbounder");
        this.m_marshaller.setProperty("jaxb.formatted.output", (Object)true);
        this.m_config = config;
        this.setNaglesDelay(this.m_config.getNaglesDelay());
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.m_config.isEnabled()) {
            return false;
        }
        if (alarm.getAlarmType() == null) {
            return false;
        }
        if (alarm.getAlarmType() == NorthboundAlarm.AlarmType.NOTIFICATION) {
            return false;
        }
        if (this.m_config.getAcceptableUeis() != null && this.m_config.getAcceptableUeis().size() != 0 && !this.m_config.getAcceptableUeis().contains(alarm.getUei())) {
            return false;
        }
        Map<String, String> alarmParms = this.getParameterMap(alarm.getEventParms());
        if (!alarmParms.containsKey(COMPONENT_TYPE)) {
            return false;
        }
        if (!alarmParms.containsKey(COMPONENT_FOREIGN_SOURCE)) {
            return false;
        }
        if (!alarmParms.containsKey(COMPONENT_FOREIGN_ID)) {
            return false;
        }
        if (!alarmParms.containsKey(COMPONENT_NAME)) {
            return false;
        }
        return "Service".equals(alarmParms.get(COMPONENT_TYPE));
    }

    private ServiceAlarmNotification toServiceAlarms(List<NorthboundAlarm> alarms) {
        ArrayList<ServiceAlarm> serviceAlarms = new ArrayList<ServiceAlarm>(alarms.size());
        for (NorthboundAlarm alarm : alarms) {
            serviceAlarms.add(this.toServiceAlarm(alarm));
        }
        return new ServiceAlarmNotification(serviceAlarms);
    }

    private ServiceAlarm toServiceAlarm(NorthboundAlarm alarm) {
        NorthboundAlarm.AlarmType alarmType = alarm.getAlarmType();
        Map<String, String> alarmParms = this.getParameterMap(alarm.getEventParms());
        String id = alarmParms.get(COMPONENT_FOREIGN_SOURCE) + ":" + alarmParms.get(COMPONENT_FOREIGN_ID);
        String name = alarmParms.get(COMPONENT_NAME);
        return new ServiceAlarm(id, name, alarmType == NorthboundAlarm.AlarmType.PROBLEM ? "Down" : "Up");
    }

    Map<String, String> getParameterMap(String parmString) {
        String[] parms;
        HashMap<String, String> parmMap = new HashMap<String, String>();
        for (String parm : parms = parmString.split(";")) {
            int eq;
            if (!parm.endsWith("(string,text)") || 0 >= (eq = (parm = parm.substring(0, parm.length() - "(string,text)".length())).indexOf(61)) || eq >= parm.length()) continue;
            String key = parm.substring(0, eq);
            String val = parm.substring(eq + 1);
            parmMap.put(key, val);
        }
        return parmMap;
    }

    public void forwardAlarms(List<NorthboundAlarm> alarms) throws NorthbounderException {
        if (!this.m_config.isEnabled()) {
            return;
        }
        LogUtils.infof((Object)((Object)this), (String)"Forwarding %d alarms", (Object[])new Object[]{alarms.size()});
        HttpEntity entity = this.createEntity(alarms);
        this.postAlarms(entity);
    }

    private void postAlarms(HttpEntity entity) {
        int code;
        HttpResponseRange range;
        int connectionTimeout = 3000;
        int socketTimeout = 3000;
        Integer retryCount = 3;
        HttpVersion httpVersion = this.determineHttpVersion(this.m_config.getHttpVersion());
        String policy = "compatibility";
        URI uri = this.m_config.getURI();
        DefaultHttpClient client = new DefaultHttpClient(this.buildParams(httpVersion, connectionTimeout, socketTimeout, policy, this.m_config.getVirtualHost()));
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(retryCount.intValue(), false));
        if ("https".equals(uri.getScheme())) {
            SchemeRegistry registry = client.getConnectionManager().getSchemeRegistry();
            Scheme https = registry.getScheme("https");
            SSLSocketFactory factory = null;
            try {
                factory = new SSLSocketFactory(SSLContext.getInstance("EmptyKeyRelaxedTrust"), SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            }
            catch (Throwable e) {
                throw new NorthbounderException(e);
            }
            Scheme lenient = new Scheme(https.getName(), https.getDefaultPort(), (SchemeSocketFactory)factory);
            registry.register(lenient);
        }
        HttpEntityEnclosingRequestBase method = this.m_config.getMethod().getRequestMethod(uri);
        method.setEntity(entity);
        method.getParams().setParameter("http.useragent", (Object)this.m_config.getUserAgent());
        HttpResponse response = null;
        try {
            response = client.execute((HttpUriRequest)method);
        }
        catch (ClientProtocolException e) {
            throw new NorthbounderException((Throwable)e);
        }
        catch (IOException e) {
            throw new NorthbounderException((Throwable)e);
        }
        if (response != null && !(range = new HttpResponseRange("200-399")).contains(code = response.getStatusLine().getStatusCode())) {
            System.err.println("response code out of range for uri:" + uri + ".  Expected " + range + " but received " + code);
            throw new NorthbounderException("response code out of range for uri:" + uri + ".  Expected " + range + " but received " + code);
        }
        System.err.println(response != null ? response.getStatusLine().getReasonPhrase() : "Response was null");
        LogUtils.debugf((Object)((Object)this), (String)(response != null ? response.getStatusLine().getReasonPhrase() : "Response was null"), (Object[])new Object[0]);
    }

    private HttpEntity createEntity(List<NorthboundAlarm> alarms) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.m_marshaller.marshal((Object)this.toServiceAlarms(alarms), (OutputStream)out);
            byte[] utf8 = out.toByteArray();
            ByteArrayEntity entity = new ByteArrayEntity(utf8);
            entity.setContentType("application/xml");
            return entity;
        }
        catch (JAXBException e) {
            throw new NorthbounderException("failed to convert alarms to xml", (Throwable)e);
        }
    }

    private HttpVersion determineHttpVersion(String version) {
        HttpVersion httpVersion = null;
        httpVersion = version != "1.0" ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0;
        return httpVersion;
    }

    private HttpParams buildParams(HttpVersion protocolVersion, int connectionTimeout, int socketTimeout, String policy, String vHost) {
        BasicHttpParams parms = new BasicHttpParams();
        parms.setParameter("http.protocol.version", (Object)protocolVersion);
        parms.setIntParameter("http.connection.timeout", connectionTimeout);
        parms.setIntParameter("http.socket.timeout", socketTimeout);
        parms.setParameter("http.protocol.cookie-policy", (Object)policy);
        if (vHost != null) {
            parms.setParameter("http.virtual-host", (Object)new HttpHost(vHost, 8080));
        }
        return parms;
    }

    public NCSNorthbounderConfig getConfig() {
        return this.m_config;
    }

    public void setConfig(NCSNorthbounderConfig config) {
        this.m_config = config;
    }

    static {
        Security.addProvider((Provider)new EmptyKeyRelaxedTrustProvider());
    }
}

