/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.correlation.ncs;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.correlation.ncs.NCSCorrelationService;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.model.ncs.NCSComponent;
import org.opennms.netmgt.model.ncs.NCSComponentRepository;
import org.opennms.netmgt.xml.event.Event;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DefaultNCSCorrelationService
implements NCSCorrelationService {
    @Autowired
    NCSComponentRepository m_componentRepo;
    @Autowired
    NodeDao m_nodeDao;

    @Override
    public List<NCSComponent> findComponentsThatDependOn(Long componentId) {
        NCSComponent comp = this.m_componentRepo.get(componentId);
        List parents = this.m_componentRepo.findComponentsThatDependOn(comp);
        for (NCSComponent parent : parents) {
            this.m_componentRepo.initialize((Object)parent);
        }
        return parents;
    }

    @Override
    public List<NCSComponent> findComponentsByNodeIdAndEventParameters(Event e, String ... parameterNames) {
        assert (e.getNodeid() != null);
        assert (e.getNodeid() != 0L);
        List components = this.m_componentRepo.findComponentsByNodeId(e.getNodeid().intValue());
        LinkedList<NCSComponent> matching = new LinkedList<NCSComponent>();
        for (NCSComponent component : components) {
            if (!this.matches(component, e, parameterNames)) continue;
            matching.add(component);
        }
        return matching;
    }

    private boolean matches(NCSComponent component, Event e, String ... parameters) {
        for (String key : parameters) {
            if (!component.getAttributes().containsKey(key)) {
                return false;
            }
            String val = (String)component.getAttributes().get(key);
            if (val.equals(EventUtils.getParm((Event)e, (String)key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<NCSComponent> findSubComponents(Long componentId) {
        NCSComponent comp = this.m_componentRepo.get(componentId);
        Set subcomponents = comp.getSubcomponents();
        for (NCSComponent subcomponent : subcomponents) {
            this.m_componentRepo.initialize((Object)subcomponent);
        }
        return new ArrayList<NCSComponent>(subcomponents);
    }

    @Override
    public List<NCSComponent> findComponentsByNodeIdAndAttrParmMaps(Event e, NCSCorrelationService.AttrParmMap ... parameterMap) {
        assert (e.getNodeid() != null);
        assert (e.getNodeid() != 0L);
        List components = this.m_componentRepo.findComponentsByNodeId(e.getNodeid().intValue());
        LinkedList<NCSComponent> matching = new LinkedList<NCSComponent>();
        for (NCSComponent component : components) {
            if (!this.matches(component, e, parameterMap)) continue;
            matching.add(component);
        }
        return matching;
    }

    private boolean matches(NCSComponent component, Event e, NCSCorrelationService.AttrParmMap[] parameterMap) {
        for (NCSCorrelationService.AttrParmMap map : parameterMap) {
            if (map.matches(component, e)) continue;
            return false;
        }
        return true;
    }
}

