/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.common.kafka;

import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.ListTopicsResult;
import org.opennms.core.ipc.common.kafka.OnmsKafkaConfigProvider;
import org.opennms.core.ipc.common.kafka.OsgiKafkaConfigProvider;
import org.opennms.distributed.core.api.Identity;
import org.opennms.distributed.core.api.SystemType;
import org.osgi.service.cm.ConfigurationAdmin;

public class Utils {
    public static <T> T runWithNullContextClassLoader(Supplier<T> supplier) {
        return Utils.runWithGivenClassLoader(supplier, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithGivenClassLoader(Supplier<T> supplier, ClassLoader classLoader) {
        Objects.requireNonNull(supplier);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            T t = supplier.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    public static Set<String> getTopics(Properties kafkaConfig) throws ExecutionException, InterruptedException {
        try (AdminClient client = Utils.runWithGivenClassLoader(() -> AdminClient.create((Properties)kafkaConfig), KafkaAdminClient.class.getClassLoader());){
            ListTopicsResult listTopicsResult = client.listTopics();
            Set set = (Set)listTopicsResult.names().get();
            return set;
        }
    }

    public static Properties getKafkaConfig(Identity identity, ConfigurationAdmin configAdmin, String type) {
        if (identity.getType().equals(SystemType.OpenNMS.name())) {
            String sysPropPrefix = type.equals("Sink") ? "org.opennms.core.ipc.sink.kafka." : "org.opennms.core.ipc.rpc.kafka.";
            OnmsKafkaConfigProvider kafkaConfigProvider = new OnmsKafkaConfigProvider(sysPropPrefix);
            return kafkaConfigProvider.getProperties();
        }
        String pid = null;
        pid = identity.getType().equals(SystemType.Minion.name()) ? (type.equals("Sink") ? "org.opennms.core.ipc.sink.kafka" : "org.opennms.core.ipc.rpc.kafka") : (type.equals("Sink") ? "org.opennms.core.ipc.sink.kafka.consumer" : "org.opennms.core.ipc.rpc.kafka");
        OsgiKafkaConfigProvider kafkaConfigProvider = new OsgiKafkaConfigProvider(pid, configAdmin);
        return kafkaConfigProvider.getProperties();
    }
}

