/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.vmmgr;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.netmgt.vmmgr.Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusGetter {
    private static final Logger LOG = LoggerFactory.getLogger(StatusGetter.class);
    public static final Pattern SERVICE_STATUS_PATTERN = Pattern.compile("Status: OpenNMS:Name=(\\S+) = (\\S+)");
    private Status m_status = Status.UNKNOWN;
    private final Controller m_controller;

    public StatusGetter(Controller controller) {
        this.m_controller = controller;
    }

    public Status getStatus() {
        return this.m_status;
    }

    public Map<String, String> retrieveStatus() throws IllegalStateException {
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        try {
            List statusResults = (List)this.m_controller.doInvokeOperation("status");
            for (String result : statusResults) {
                Matcher m = SERVICE_STATUS_PATTERN.matcher(result);
                if (!m.matches()) {
                    throw new IllegalStateException("Result \"" + result + "\" does not match our regular expression");
                }
                results.put(m.group(1), m.group(2).toLowerCase());
            }
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unable to retrieve status from running services.", e);
        }
        return results;
    }

    public void queryStatus() throws Exception {
        Map<Object, Object> results = Collections.emptyMap();
        try {
            results = this.retrieveStatus();
        }
        catch (IllegalStateException e) {
            LOG.debug("Could not fetch status: " + e.getMessage());
            if (this.m_controller.isVerbose()) {
                System.out.println("Could not connect to the OpenNMS JVM (OpenNMS might not be running or could be starting up or shutting down): " + e.getMessage());
            }
            this.m_status = Status.CONNECTION_REFUSED;
            return;
        }
        String spaces = "                    ";
        int running = 0;
        int services = 0;
        for (Map.Entry<Object, Object> entry : results.entrySet()) {
            String daemon = (String)entry.getKey();
            String status = (String)entry.getValue();
            ++services;
            if (status.equals("running")) {
                ++running;
            }
            if (!this.m_controller.isVerbose()) continue;
            System.out.println("OpenNMS." + daemon + spaces.substring(Math.min(daemon.length(), spaces.length() - 1)) + ": " + status);
        }
        this.m_status = services == 0 ? Status.NOT_RUNNING : (running != services ? Status.PARTIALLY_RUNNING : Status.RUNNING);
    }

    public static enum Status {
        UNKNOWN,
        RUNNING,
        PARTIALLY_RUNNING,
        NOT_RUNNING,
        CONNECTION_REFUSED;

    }
}

