/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedLong;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.time.Instant;
import java.util.function.Function;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.LocRibFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;

public class PeerHeader {
    public final Type type;
    public final PeerFlags flags;
    public final LocRibFlags locRibFlags;
    public final UnsignedLong distinguisher;
    public final InetAddress address;
    public final long as;
    public final InetAddress id;
    public final Instant timestamp;

    public PeerHeader(ByteBuf buffer) throws InvalidPacketException {
        this.type = Type.from(buffer);
        if (this.type == Type.LOC_RIB_INSTANCE) {
            this.flags = null;
            this.locRibFlags = new LocRibFlags(BufferUtils.uint8((ByteBuf)buffer));
        } else {
            this.flags = new PeerFlags(BufferUtils.uint8((ByteBuf)buffer));
            this.locRibFlags = null;
        }
        this.distinguisher = BufferUtils.uint64((ByteBuf)buffer);
        this.address = this.flags.parsePaddedAddress(buffer);
        this.as = BufferUtils.uint32((ByteBuf)buffer);
        this.id = InetAddressUtils.getInetAddress((byte[])BufferUtils.bytes((ByteBuf)buffer, (int)4));
        this.timestamp = Instant.ofEpochSecond(BufferUtils.uint32((ByteBuf)buffer), BufferUtils.uint32((ByteBuf)buffer) * 1000L);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("config", (Object)this.flags).add("distinguisher", (Object)this.distinguisher).add("address", (Object)this.address).add("as", this.as).add("id", (Object)this.id).add("timestamp", (Object)this.timestamp).toString();
    }

    public static enum Type {
        GLOBAL_INSTANCE,
        RD_INSTANCE,
        LOCAL_INSTANCE,
        LOC_RIB_INSTANCE;


        private static Type from(ByteBuf buffer) throws InvalidPacketException {
            int type = BufferUtils.uint8((ByteBuf)buffer);
            switch (type) {
                case 0: {
                    return GLOBAL_INSTANCE;
                }
                case 1: {
                    return RD_INSTANCE;
                }
                case 2: {
                    return LOCAL_INSTANCE;
                }
                case 3: {
                    return LOC_RIB_INSTANCE;
                }
            }
            throw new InvalidPacketException(buffer, "Unknown peer type: %d", type);
        }

        public <R> R map(Function<Type, R> mapper) {
            return mapper.apply(this);
        }
    }
}

