/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser;

import io.github.resilience4j.bulkhead.Bulkhead;
import io.github.resilience4j.bulkhead.BulkheadConfig;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.telemetry.api.receiver.Parser;
import org.opennms.netmgt.telemetry.api.receiver.ParserFactory;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.config.api.ParserDefinition;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;

public class BmpParserFactory
implements ParserFactory {
    public static final String MAX_CONCURRENT_CALLS_KEY = "bulkhead.maxConcurrentCalls";
    public static final long DEFAULT_MAX_CONCURRENT_CALLS = 1000L;
    public static final String MAX_WAIT_DURATION_MS_KEY = "bulkhead.maxWaitDurationMs";
    public static final long DEFAULT_MAX_WAIT_DURATION_MS = TimeUnit.MINUTES.toMillis(5L);
    private final TelemetryRegistry telemetryRegistry;
    private final DnsResolver dnsResolver;

    public BmpParserFactory(TelemetryRegistry telemetryRegistry, DnsResolver dnsResolver) {
        this.telemetryRegistry = Objects.requireNonNull(telemetryRegistry);
        this.dnsResolver = Objects.requireNonNull(dnsResolver);
    }

    public Class<? extends Parser> getBeanClass() {
        return BmpParser.class;
    }

    public Parser createBean(ParserDefinition parserDefinition) {
        AsyncDispatcher dispatcher = this.telemetryRegistry.getDispatcher(parserDefinition.getQueueName());
        Bulkhead bulkhead = BmpParserFactory.createBulkhead(parserDefinition);
        return new BmpParser(parserDefinition.getFullName(), (AsyncDispatcher<TelemetryMessage>)dispatcher, this.dnsResolver, bulkhead, this.telemetryRegistry.getMetricRegistry());
    }

    private static Bulkhead createBulkhead(ParserDefinition parserDefinition) {
        Map parameters = parserDefinition.getParameterMap();
        long maxConcurrentCalls = Optional.ofNullable(parameters.remove(MAX_CONCURRENT_CALLS_KEY)).map(Long::parseLong).orElse(1000L);
        long maxWaitDurationMs = Optional.ofNullable(parameters.remove(MAX_WAIT_DURATION_MS_KEY)).map(Long::parseLong).orElse(DEFAULT_MAX_WAIT_DURATION_MS);
        BulkheadConfig bulkheadConfig = BulkheadConfig.custom().maxConcurrentCalls((int)maxConcurrentCalls).maxWaitDuration(Duration.ofMillis(maxWaitDurationMs)).build();
        return Bulkhead.of((String)("BmpParser-" + parserDefinition.getFullName()), (BulkheadConfig)bulkheadConfig);
    }
}

