/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import ndr.NetworkDataRepresentation;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.JIMarshalUnMarshalHelper;
import org.jinterop.dcom.core.JIPointer;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIStruct;
import org.jinterop.dcom.core.JIUnion;

public final class JIArray
implements Serializable {
    private static final long serialVersionUID = -8267477025978489665L;
    private Object memberArray = null;
    private Class clazz = null;
    private int[] upperBounds = null;
    private int dimension = -1;
    private int numElementsInAllDimensions = 0;
    private boolean isConformant = false;
    private boolean isVarying = false;
    private boolean isConformantProxy = false;
    private boolean isVaryingProxy = false;
    private List conformantMaxCounts = new ArrayList();
    private Object template = null;
    private int sizeOfNestedArrayInBytes = 0;

    private JIArray() {
    }

    public JIArray(Class clazz, int[] upperBounds, int dimension, boolean isConformant) {
        this.clazz = clazz;
        this.init2(upperBounds, dimension, isConformant, false);
    }

    public JIArray(Class clazz, int[] upperBounds, int dimension, boolean isConformant, boolean isVarying) {
        this.clazz = clazz;
        this.init2(upperBounds, dimension, isConformant, isVarying);
    }

    public JIArray(Object template, int[] upperBounds, int dimension, boolean isConformant) {
        if (template == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4114));
        }
        if (!(template.getClass().equals(JIStruct.class) || template.getClass().equals(JIUnion.class) || template.getClass().equals(JIPointer.class) || template.getClass().equals(JIString.class))) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4117));
        }
        this.template = template;
        this.clazz = template.getClass();
        this.init2(upperBounds, dimension, isConformant, false);
    }

    public JIArray(Object template, int[] upperBounds, int dimension, boolean isConformant, boolean isVarying) {
        if (template == null) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4114));
        }
        if (!(template.getClass().equals(JIStruct.class) || template.getClass().equals(JIUnion.class) || template.getClass().equals(JIPointer.class) || template.getClass().equals(JIString.class))) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4117));
        }
        this.template = template;
        this.clazz = template.getClass();
        this.init2(upperBounds, dimension, isConformant, isVarying);
    }

    private void init2(int[] upperBounds, int dimension, boolean isConformant, boolean isVarying) {
        this.upperBounds = upperBounds;
        this.dimension = dimension;
        this.isConformant = isConformant;
        this.isConformantProxy = isConformant;
        this.isVarying = isVarying;
        this.isVaryingProxy = isVarying;
        if (upperBounds != null && upperBounds.length != dimension) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4136));
        }
        for (int i = 0; upperBounds != null && i < upperBounds.length; ++i) {
            this.numElementsInAllDimensions += upperBounds[i];
            if (!isConformant) continue;
            this.conformantMaxCounts.add(new Integer(upperBounds[i]));
        }
    }

    public JIArray(Object array, boolean isConformant) {
        this.isConformant = isConformant;
        this.isConformantProxy = isConformant;
        this.init(array);
    }

    public JIArray(Object array, boolean isConformant, boolean isVarying) {
        this.isConformant = isConformant;
        this.isConformantProxy = isConformant;
        this.isVarying = isVarying;
        this.isVaryingProxy = isVarying;
        this.init(array);
    }

    public JIArray(Object array) {
        this.init(array);
    }

    private void init(Object array) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4115));
        }
        if (array.getClass().isPrimitive()) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4116));
        }
        if (array.getClass().toString().indexOf("java.lang.Object") != -1) {
            throw new IllegalArgumentException(JISystem.getLocalizedMessage(4162));
        }
        this.memberArray = array;
        ArrayList<Integer> upperBounds2 = new ArrayList<Integer>();
        String name = array.getClass().getName();
        Object subArray = array;
        this.numElementsInAllDimensions = 1;
        while (name.startsWith("[")) {
            name = name.substring(1);
            int x = ((Object[])subArray).length;
            upperBounds2.add(new Integer(x));
            this.numElementsInAllDimensions *= x;
            if (this.isConformant) {
                this.conformantMaxCounts.add(new Integer(x));
            }
            this.clazz = subArray.getClass().getComponentType();
            if (x == 0) break;
            subArray = Array.get(subArray, 0);
            ++this.dimension;
        }
        if (this.dimension == -1) {
            this.numElementsInAllDimensions = 0;
            ++this.dimension;
        }
        this.upperBounds = new int[upperBounds2.size()];
        for (int i = 0; i < upperBounds2.size(); ++i) {
            this.upperBounds[i] = ((Number)upperBounds2.get(i)).intValue();
        }
        ++this.dimension;
        this.sizeOfNestedArrayInBytes = this.computeLengthArray(array);
    }

    private int computeLengthArray(Object array) {
        int length = 0;
        String name = array.getClass().getName();
        Object[] o = (Object[])array;
        for (int i = 0; i < o.length; ++i) {
            if (name.charAt(1) != '[') {
                Object[] o1 = (Object[])array;
                for (int j = 0; j < o1.length; ++j) {
                    length += JIMarshalUnMarshalHelper.getLengthInBytes(o1.getClass().getComponentType(), o1[j], 0);
                }
                return length;
            }
            length += this.computeLengthArray(Array.get(array, i));
        }
        return length;
    }

    public Object getArrayInstance() {
        return this.memberArray;
    }

    public Class getArrayClass() {
        return this.clazz;
    }

    public int[] getUpperBounds() {
        return this.upperBounds;
    }

    public int getDimensions() {
        return this.dimension;
    }

    int getSizeOfAllElementsInBytes() {
        if (this.sizeOfNestedArrayInBytes == -1) {
            this.sizeOfNestedArrayInBytes = this.computeLengthArray(this.memberArray);
        }
        return this.sizeOfNestedArrayInBytes;
    }

    void encode(NetworkDataRepresentation ndr, Object array, List defferedPointers, int FLAG) {
        int i;
        if (this.isConformantProxy) {
            for (i = 0; i < this.conformantMaxCounts.size(); ++i) {
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, this.conformantMaxCounts.get(i), defferedPointers, FLAG);
            }
            this.isConformantProxy = false;
        }
        if (this.isVaryingProxy) {
            for (i = 0; i < this.conformantMaxCounts.size(); ++i) {
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, new Integer(0), defferedPointers, FLAG);
                JIMarshalUnMarshalHelper.serialize(ndr, Integer.class, this.conformantMaxCounts.get(i), defferedPointers, FLAG);
            }
            this.isVaryingProxy = false;
        }
        String name = array.getClass().getName();
        Object[] o = (Object[])array;
        for (int i2 = 0; i2 < o.length; ++i2) {
            if (name.charAt(1) != '[') {
                Object[] o1 = (Object[])array;
                for (int j = 0; j < o1.length; ++j) {
                    JIMarshalUnMarshalHelper.serialize(ndr, this.clazz, o1[j], defferedPointers, FLAG | 8);
                }
                return;
            }
            this.encode(ndr, Array.get(array, i2), defferedPointers, FLAG);
        }
    }

    public boolean isConformant() {
        return this.isConformant;
    }

    public boolean isVarying() {
        return this.isVarying;
    }

    Object decode(NetworkDataRepresentation ndr, Class arrayType, int dimension, List defferedPointers, int FLAG, Map additionalData) {
        int i;
        JIArray retVal = new JIArray();
        retVal.isConformantProxy = this.isConformantProxy;
        retVal.isVaryingProxy = this.isVaryingProxy;
        if (this.isConformantProxy) {
            for (i = 0; i < dimension; ++i) {
                retVal.conformantMaxCounts.add(JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, defferedPointers, FLAG, additionalData));
            }
            if (this.upperBounds == null) {
                retVal.numElementsInAllDimensions = 0;
                retVal.upperBounds = new int[retVal.conformantMaxCounts.size()];
                for (i = 0; i < retVal.conformantMaxCounts.size(); ++i) {
                    retVal.upperBounds[i] = ((Number)retVal.conformantMaxCounts.get(i)).intValue();
                    retVal.numElementsInAllDimensions *= retVal.upperBounds[i];
                }
                if (i == 0) {
                    this.numElementsInAllDimensions = 0;
                }
            }
        } else {
            retVal.upperBounds = this.upperBounds;
            retVal.conformantMaxCounts = this.conformantMaxCounts;
            retVal.numElementsInAllDimensions = this.numElementsInAllDimensions;
        }
        if (this.isVaryingProxy) {
            retVal.conformantMaxCounts.clear();
            retVal.upperBounds = null;
            retVal.numElementsInAllDimensions = 0;
            for (i = 0; i < dimension; ++i) {
                JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, defferedPointers, FLAG, null);
                retVal.conformantMaxCounts.add(JIMarshalUnMarshalHelper.deSerialize(ndr, Integer.class, defferedPointers, FLAG, additionalData));
            }
            if (this.upperBounds == null) {
                retVal.numElementsInAllDimensions = 1;
                retVal.upperBounds = new int[retVal.conformantMaxCounts.size()];
                for (i = 0; i < retVal.conformantMaxCounts.size(); ++i) {
                    retVal.upperBounds[i] = ((Number)retVal.conformantMaxCounts.get(i)).intValue();
                    retVal.numElementsInAllDimensions *= retVal.upperBounds[i];
                }
                if (i == 0) {
                    this.numElementsInAllDimensions = 0;
                }
            }
        }
        retVal.isConformant = this.isConformant;
        retVal.isVarying = this.isVarying;
        retVal.template = this.template;
        retVal.memberArray = this.recurseDecode(retVal, ndr, arrayType, dimension, defferedPointers, FLAG, additionalData);
        retVal.clazz = this.clazz;
        retVal.dimension = this.dimension;
        retVal.sizeOfNestedArrayInBytes = -1;
        return retVal;
    }

    private Object recurseDecode(JIArray retVal, NetworkDataRepresentation ndr, Class arrayType, int dimension, List defferedPointers, int FLAG, Map additionalData) {
        Object array = null;
        Class<?> c = arrayType;
        for (int j = 0; j < dimension; ++j) {
            array = Array.newInstance(c, retVal.upperBounds[retVal.upperBounds.length - j - 1]);
            c = array.getClass();
        }
        for (int i = 0; i < retVal.upperBounds[retVal.upperBounds.length - dimension]; ++i) {
            if (dimension == 1) {
                if (this.template == null) {
                    Array.set(array, i, JIMarshalUnMarshalHelper.deSerialize(ndr, c.getComponentType() == null ? c : c.getComponentType(), defferedPointers, FLAG | 8, additionalData));
                    continue;
                }
                Array.set(array, i, JIMarshalUnMarshalHelper.deSerialize(ndr, this.template, defferedPointers, FLAG | 8, additionalData));
                continue;
            }
            Array.set(array, i, this.recurseDecode(retVal, ndr, arrayType, dimension - 1, defferedPointers, FLAG, additionalData));
        }
        return array;
    }

    int reverseArrayForDispatch() {
        if (this.memberArray == null) {
            return 0;
        }
        int i = 0;
        Stack<Object> stack = new Stack<Object>();
        for (i = 0; i < ((Object[])this.memberArray).length; ++i) {
            stack.push(((Object[])this.memberArray)[i]);
        }
        i = 0;
        while (stack.size() > 0) {
            ((Object[])this.memberArray)[i++] = stack.pop();
        }
        return i;
    }

    List getConformantMaxCounts() {
        return this.conformantMaxCounts;
    }

    void setConformant(boolean isConformant) {
        this.isConformantProxy = isConformant;
    }

    void setVarying(boolean isVarying) {
        this.isVaryingProxy = isVarying;
    }

    void setMaxCountAndUpperBounds(List maxCount) {
        this.conformantMaxCounts = maxCount;
        if (this.conformantMaxCounts.size() > 0) {
            int i;
            this.numElementsInAllDimensions = 1;
            this.upperBounds = new int[this.conformantMaxCounts.size()];
            for (i = 0; i < this.conformantMaxCounts.size(); ++i) {
                this.upperBounds[i] = ((Number)this.conformantMaxCounts.get(i)).intValue();
                this.numElementsInAllDimensions *= this.upperBounds[i];
            }
            if (i == 0) {
                this.numElementsInAllDimensions = 0;
            }
        } else {
            this.upperBounds = null;
            this.numElementsInAllDimensions = 0;
        }
    }

    int getNumElementsInAllDimensions() {
        return this.numElementsInAllDimensions;
    }

    void updateClazz(Class c) {
        this.clazz = c;
    }

    public String toString() {
        String retVal = "[Type: " + this.clazz + " , ";
        retVal = this.memberArray == null ? retVal + "memberArray is null , " : retVal + this.memberArray + " , ";
        if (this.isConformant) {
            retVal = retVal + " conformant , ";
        }
        if (this.isVarying) {
            retVal = retVal + " varying , ";
        }
        return retVal + "]";
    }
}

