/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.distributed.core.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.opennms.distributed.core.api.RestClient;
import org.opennms.features.scv.api.Credentials;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScvEnabledRestClientImpl
implements RestClient {
    public static final Logger LOG = LoggerFactory.getLogger(ScvEnabledRestClientImpl.class);
    private static final String VERSION_KEY = "version";
    private final URL url;
    private final SecureCredentialsVault scv;
    private final String scvAlias;

    public ScvEnabledRestClientImpl(String url, SecureCredentialsVault scv, String scvAlias) throws MalformedURLException {
        this.url = new URL(Objects.requireNonNull(url));
        this.scv = Objects.requireNonNull(scv);
        this.scvAlias = Objects.requireNonNull(scvAlias);
    }

    private UsernamePasswordCredentials getCredentials() {
        Credentials credentials = this.scv.getCredentials(this.scvAlias);
        if (credentials == null) {
            LOG.warn("No credentials found in SCV for alias '{}'. Using default credentials.", (Object)this.scvAlias);
            return new UsernamePasswordCredentials("admin", "admin");
        }
        return new UsernamePasswordCredentials(credentials.getUsername(), credentials.getPassword());
    }

    private CloseableHttpResponse getResponse(HttpGet httpget) throws Exception {
        CloseableHttpResponse response = null;
        HttpHost target = new HttpHost(this.url.getHost(), this.url.getPort(), this.url.getProtocol());
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(new AuthScope(target.getHostName(), target.getPort()), (org.apache.http.auth.Credentials)this.getCredentials());
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(target, (AuthScheme)basicAuth);
        HttpClientContext localContext = HttpClientContext.create();
        localContext.setAuthCache((AuthCache)authCache);
        response = httpclient.execute(target, (HttpRequest)httpget, (HttpContext)localContext);
        return response;
    }

    /*
     * Exception decompiling
     */
    public String getVersion() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void ping() throws Exception {
        if (this.getVersion() == null) {
            throw new Exception("Server did not return a version.");
        }
    }

    public String getSnmpV3Users() throws Exception {
        String responseString = null;
        CloseableHttpResponse response = null;
        HttpGet httpget = new HttpGet(this.url.toExternalForm() + "/rest/config/trapd");
        response = this.getResponse(httpget);
        HttpEntity entity = response.getEntity();
        responseString = EntityUtils.toString((HttpEntity)entity);
        response.close();
        return responseString;
    }
}

