/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Scope;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.SequenceNumberTracker;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Template;

public class TcpSession
implements Session {
    private final InetAddress remoteAddress;
    private final Map<TemplateKey, Template> templates = Maps.newHashMap();
    private final Map<TemplateKey, Map<Set<Value<?>>, List<Value<?>>>> options = Maps.newHashMap();
    private final Map<Long, SequenceNumberTracker> sequenceNumbers = Maps.newHashMap();

    public TcpSession(InetAddress remoteAddress) {
        this.remoteAddress = Objects.requireNonNull(remoteAddress);
    }

    @Override
    public void addTemplate(long observationDomainId, Template template) {
        this.templates.put(new TemplateKey(observationDomainId, template.id), template);
    }

    @Override
    public void removeTemplate(long observationDomainId, int templateId) {
        this.templates.remove(new TemplateKey(observationDomainId, templateId));
    }

    @Override
    public void removeAllTemplate(long observationDomainId, Template.Type type) {
        this.templates.entrySet().removeIf(e -> ((TemplateKey)e.getKey()).observationDomainId == observationDomainId && ((Template)e.getValue()).type == type);
    }

    @Override
    public void addOptions(long observationDomainId, int templateId, Collection<Value<?>> scopes, List<Value<?>> values) {
        TemplateKey key = new TemplateKey(observationDomainId, templateId);
        this.options.computeIfAbsent(key, k -> new HashMap()).put(new HashSet(scopes), values);
    }

    @Override
    public Session.Resolver getResolver(long observationDomainId) {
        return new Resolver(observationDomainId);
    }

    @Override
    public InetAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public boolean verifySequenceNumber(long observationDomainId, long sequenceNumber) {
        SequenceNumberTracker tracker = this.sequenceNumbers.computeIfAbsent(observationDomainId, k -> new SequenceNumberTracker());
        return tracker.verify(sequenceNumber);
    }

    private static final class TemplateKey {
        public final long observationDomainId;
        public final int templateId;

        TemplateKey(long observationDomainId, int templateId) {
            this.observationDomainId = observationDomainId;
            this.templateId = templateId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o.getClass() != TemplateKey.class) {
                return false;
            }
            TemplateKey that = (TemplateKey)o;
            return this.observationDomainId == that.observationDomainId && this.templateId == that.templateId;
        }

        public int hashCode() {
            return Objects.hash(this.observationDomainId, this.templateId);
        }
    }

    private final class Resolver
    implements Session.Resolver {
        private final long observationDomainId;

        private Resolver(long observationDomainId) {
            this.observationDomainId = observationDomainId;
        }

        @Override
        public Template lookupTemplate(int templateId) throws MissingTemplateException {
            TemplateKey key = new TemplateKey(this.observationDomainId, templateId);
            Template template = (Template)TcpSession.this.templates.get(key);
            if (template != null) {
                return template;
            }
            throw new MissingTemplateException(templateId);
        }

        @Override
        public List<Value<?>> lookupOptions(List<Value<?>> values) {
            LinkedHashMap<String, Value> options = new LinkedHashMap<String, Value>();
            Set scoped = values.stream().map(Value::getName).collect(Collectors.toSet());
            for (Map.Entry e2 : Iterables.filter(TcpSession.this.options.entrySet(), e -> ((TemplateKey)e.getKey()).observationDomainId == this.observationDomainId)) {
                Template template = (Template)TcpSession.this.templates.get(e2.getKey());
                Set scopes = template.scopes.stream().map(Scope::getName).collect(Collectors.toSet());
                if (!scoped.containsAll(scopes)) continue;
                Set scopeValues = values.stream().filter(s -> scopes.contains(s.getName())).collect(Collectors.toSet());
                for (Value value : ((Map)e2.getValue()).getOrDefault(scopeValues, Collections.emptyList())) {
                    options.put(value.getName(), value);
                }
            }
            return new ArrayList(options.values());
        }
    }
}

