/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.model;

import java.io.File;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import org.opennms.netmgt.model.OnmsEntity;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourcePath;
import org.opennms.netmgt.rrd.RrdRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.ObjectRetrievalFailureException;

public abstract class ResourceTypeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceTypeUtils.class);
    public static final File DEFAULT_RRD_ROOT = Paths.get("share", "rrd").toAbsolutePath().toFile();
    public static final String RESPONSE_DIRECTORY = "response";
    public static final String SNMP_DIRECTORY = "snmp";
    public static final String FOREIGN_SOURCE_DIRECTORY = "fs";
    private static final Pattern s_responseDirectoryPattern = Pattern.compile("^response.+$");

    public static boolean isStoreByGroup() {
        return Boolean.getBoolean("org.opennms.rrd.storeByGroup");
    }

    public static boolean isStoreByForeignSource() {
        return Boolean.getBoolean("org.opennms.rrd.storeByForeignSource");
    }

    public static boolean isResponseTime(String relativePath) {
        return s_responseDirectoryPattern.matcher(relativePath).matches();
    }

    public static File getRelativeNodeSourceDirectory(String nodeSource) {
        String[] ident = ResourceTypeUtils.getFsAndFidFromNodeSource(nodeSource);
        return new File(FOREIGN_SOURCE_DIRECTORY, File.separator + ident[0] + File.separator + ident[1]);
    }

    public static String[] getFsAndFidFromNodeSource(String nodeSource) {
        String[] ident = nodeSource.split(":", 2);
        if (ident.length != 2) {
            LOG.warn("'{}' is not in the format foreignSource:foreignId.", (Object)nodeSource);
            throw new IllegalArgumentException("Node definition '" + nodeSource + "' is invalid, it should be in the format: 'foreignSource:foreignId'.");
        }
        return ident;
    }

    public static OnmsNode getNodeFromResource(OnmsResource resource) {
        if (resource == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)"Resource must be non-null.");
        }
        OnmsEntity entity = resource.getEntity();
        if (entity == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)("Resource entity must be non-null: " + resource));
        }
        if (!(entity instanceof OnmsNode)) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)("Resource entity must be an instance of OnmsNode: " + resource));
        }
        return (OnmsNode)entity;
    }

    public static OnmsNode getNodeFromResourceRoot(OnmsResource resource) {
        OnmsResource res;
        for (res = resource; res != null && res.getParent() != null; res = res.getParent()) {
        }
        if (res == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)"Resource must be non-null.");
        }
        OnmsEntity entity = res.getEntity();
        if (entity == null) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)("Resource entity must be non-null: " + resource));
        }
        if (!(entity instanceof OnmsNode)) {
            throw new ObjectRetrievalFailureException(OnmsNode.class, (Object)("Resource entity must be an instance of OnmsNode: " + resource));
        }
        return (OnmsNode)entity;
    }

    public static ResourcePath getResourcePathWithRepository(RrdRepository repository, ResourcePath resource) {
        return ResourcePath.get(ResourcePath.get(repository.getRrdBaseDir().getName()), resource);
    }
}

