/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.transport;

import java.net.InetAddress;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.IllegalFlowException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnrichment;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.transport.MessageUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.Direction;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.FlowMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.NetflowVersion;
import org.opennms.netmgt.telemetry.protocols.netflow.transport.SamplingAlgorithm;

public class Netflow5MessageBuilder {
    private final FlowMessage.Builder builder;
    private final Iterable<Value<?>> values;
    private final RecordEnrichment enrichment;
    private Long unixSecs;
    private Long unixNSecs;
    private Long sysUpTime;
    private Long first;
    private Long last;
    private InetAddress srcAddr;
    private InetAddress dstAddr;
    private InetAddress nextHop;

    public Netflow5MessageBuilder(Iterable<Value<?>> values, RecordEnrichment enrichment) {
        this.values = values;
        this.enrichment = enrichment;
        this.builder = FlowMessage.newBuilder();
    }

    public byte[] buildData() throws IllegalFlowException {
        this.values.forEach(this::addField);
        long timeStamp = this.unixSecs * 1000L + this.unixNSecs / 1000000L;
        long bootTime = timeStamp - this.sysUpTime;
        this.builder.setNetflowVersion(NetflowVersion.V5);
        this.builder.setFirstSwitched(MessageUtils.setLongValue(bootTime + this.first));
        this.builder.setLastSwitched(MessageUtils.setLongValue(bootTime + this.last));
        this.builder.setTimestamp(timeStamp);
        if (this.srcAddr != null) {
            this.builder.setSrcAddress(this.srcAddr.getHostAddress());
            this.enrichment.getHostnameFor(this.srcAddr).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSrcHostname(arg_0));
        }
        if (this.dstAddr != null) {
            this.builder.setDstAddress(this.dstAddr.getHostAddress());
            this.enrichment.getHostnameFor(this.dstAddr).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstHostname(arg_0));
        }
        if (this.nextHop != null) {
            this.builder.setNextHopAddress(this.nextHop.getHostAddress());
            this.enrichment.getHostnameFor(this.nextHop).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setNextHopHostname(arg_0));
        }
        if (this.builder.getFirstSwitched().getValue() > this.builder.getLastSwitched().getValue()) {
            throw new IllegalFlowException(String.format("lastSwitched must be greater than firstSwitched: srcAddress=%s, dstAddress=%s, firstSwitched=%d, lastSwitched=%d, duration=%d", this.builder.getSrcAddress(), this.builder.getDstAddress(), this.builder.getFirstSwitched().getValue(), this.builder.getLastSwitched().getValue(), this.builder.getLastSwitched().getValue() - this.builder.getFirstSwitched().getValue()));
        }
        return this.builder.build().toByteArray();
    }

    private void addField(Value<?> value) {
        switch (value.getName()) {
            case "@count": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setNumFlowRecords(arg_0));
                break;
            }
            case "@unixSecs": {
                this.unixSecs = MessageUtils.getLongValue(value);
                break;
            }
            case "@unixNSecs": {
                this.unixNSecs = MessageUtils.getLongValue(value);
                break;
            }
            case "@sysUptime": {
                this.sysUpTime = MessageUtils.getLongValue(value);
                break;
            }
            case "@flowSequence": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setFlowSeqNum(arg_0));
                break;
            }
            case "@engineType": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setEngineType(arg_0));
                break;
            }
            case "@engineId": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setEngineId(arg_0));
                break;
            }
            case "@samplingAlgorithm": {
                Long saValue = MessageUtils.getLongValue(value);
                SamplingAlgorithm samplingAlgorithm = SamplingAlgorithm.UNASSIGNED;
                if (saValue != null) {
                    switch (saValue.intValue()) {
                        case 1: {
                            samplingAlgorithm = SamplingAlgorithm.SYSTEMATIC_COUNT_BASED_SAMPLING;
                            break;
                        }
                        case 2: {
                            samplingAlgorithm = SamplingAlgorithm.RANDOM_N_OUT_OF_N_SAMPLING;
                        }
                    }
                }
                this.builder.setSamplingAlgorithm(samplingAlgorithm);
                break;
            }
            case "@samplingInterval": {
                MessageUtils.getDoubleValue(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSamplingInterval(arg_0));
                break;
            }
            case "srcAddr": {
                this.srcAddr = MessageUtils.getInetAddress(value);
                break;
            }
            case "dstAddr": {
                this.dstAddr = MessageUtils.getInetAddress(value);
                break;
            }
            case "nextHop": {
                this.nextHop = MessageUtils.getInetAddress(value);
                break;
            }
            case "input": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setInputSnmpIfindex(arg_0));
                break;
            }
            case "output": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setOutputSnmpIfindex(arg_0));
                break;
            }
            case "dPkts": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setNumPackets(arg_0));
                break;
            }
            case "dOctets": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setNumBytes(arg_0));
                break;
            }
            case "first": {
                this.first = MessageUtils.getLongValue(value);
                break;
            }
            case "last": {
                this.last = MessageUtils.getLongValue(value);
                break;
            }
            case "srcPort": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSrcPort(arg_0));
                break;
            }
            case "dstPort": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstPort(arg_0));
                break;
            }
            case "tcpFlags": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setTcpFlags(arg_0));
                break;
            }
            case "proto": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setProtocol(arg_0));
                break;
            }
            case "srcAs": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSrcAs(arg_0));
                break;
            }
            case "dstAs": {
                MessageUtils.getUInt64Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstAs(arg_0));
                break;
            }
            case "tos": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setTos(arg_0));
                break;
            }
            case "srcMask": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setSrcMaskLen(arg_0));
                break;
            }
            case "dstMask": {
                MessageUtils.getUInt32Value(value).ifPresent(arg_0 -> ((FlowMessage.Builder)this.builder).setDstMaskLen(arg_0));
                break;
            }
            case "egress": {
                Boolean egress = MessageUtils.getBooleanValue(value);
                Direction direction = egress != false ? Direction.EGRESS : Direction.INGRESS;
                this.builder.setDirection(direction);
            }
        }
    }
}

