/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.distributed.core.api.Identity;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.telemetry.api.receiver.Parser;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.IllegalFlowException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnricher;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.RecordEnrichment;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.RecordProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ParserBase
implements Parser {
    private static final Logger LOG = LoggerFactory.getLogger(ParserBase.class);
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private static final long DEFAULT_CLOCK_SKEW_EVENT_RATE_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private static final long DEFAULT_ILLEGAL_FLOW_EVENT_RATE_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    public static final String CLOCK_SKEW_EVENT_UEI = "uei.opennms.org/internal/telemetry/clockSkewDetected";
    public static final String ILLEGAL_FLOW_EVENT_UEI = "uei.opennms.org/internal/telemetry/illegalFlowDetected";
    private final ThreadLocal<Boolean> isParserThread = new ThreadLocal();
    private final Protocol protocol;
    private final String name;
    private final AsyncDispatcher<TelemetryMessage> dispatcher;
    private final EventForwarder eventForwarder;
    private final Identity identity;
    private final DnsResolver dnsResolver;
    private final Meter recordsDispatched;
    private final Timer recordEnrichmentTimer;
    private final ThreadFactory threadFactory;
    private int threads = DEFAULT_NUM_THREADS;
    private long maxClockSkew = 0L;
    private long clockSkewEventRate = 0L;
    private long illegalFlowEventRate = 0L;
    private boolean dnsLookupsEnabled = true;
    private LoadingCache<InetAddress, Optional<Instant>> clockSkewEventCache;
    private LoadingCache<InetAddress, Optional<Instant>> illegalFlowEventCache;
    private ExecutorService executor;

    public ParserBase(Protocol protocol, String name, AsyncDispatcher<TelemetryMessage> dispatcher, EventForwarder eventForwarder, Identity identity, DnsResolver dnsResolver, MetricRegistry metricRegistry) {
        this.protocol = Objects.requireNonNull(protocol);
        this.name = Objects.requireNonNull(name);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
        this.identity = Objects.requireNonNull(identity);
        this.dnsResolver = Objects.requireNonNull(dnsResolver);
        Objects.requireNonNull(metricRegistry);
        final LogPreservingThreadFactory logPreservingThreadFactory = new LogPreservingThreadFactory("Telemetryd-" + (Object)((Object)protocol) + "-" + name, Integer.MAX_VALUE);
        this.threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return logPreservingThreadFactory.newThread(() -> {
                    ParserBase.this.isParserThread.set(true);
                    r.run();
                });
            }
        };
        this.recordsDispatched = metricRegistry.meter(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordsDispatched"}));
        this.recordEnrichmentTimer = metricRegistry.timer(MetricRegistry.name((String)"parsers", (String[])new String[]{name, "recordEnrichment"}));
        this.setClockSkewEventRate(DEFAULT_CLOCK_SKEW_EVENT_RATE_SECONDS);
        this.setIllegalFlowEventRate(DEFAULT_ILLEGAL_FLOW_EVENT_RATE_SECONDS);
        this.setThreads(DEFAULT_NUM_THREADS);
    }

    public void start(ScheduledExecutorService executorService) {
        this.executor = new ThreadPoolExecutor(1, this.threads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this.threadFactory, (r, executor) -> {
            try {
                if (!executor.isShutdown()) {
                    executor.getQueue().put(r);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Executor interrupted while waiting for capacity in the work queue.", e);
            }
        });
    }

    public void stop() {
        this.executor.shutdown();
    }

    public String getName() {
        return this.name;
    }

    public void setMaxClockSkew(long maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public long getMaxClockSkew() {
        return this.maxClockSkew;
    }

    public long getClockSkewEventRate() {
        return this.clockSkewEventRate;
    }

    public void setClockSkewEventRate(long clockSkewEventRate) {
        this.clockSkewEventRate = clockSkewEventRate;
        this.clockSkewEventCache = CacheBuilder.newBuilder().expireAfterWrite(this.clockSkewEventRate, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<InetAddress, Optional<Instant>>(){

            public Optional<Instant> load(InetAddress key) throws Exception {
                return Optional.empty();
            }
        });
    }

    public void setIllegalFlowEventRate(long illegalFlowEventRate) {
        this.illegalFlowEventRate = illegalFlowEventRate;
        this.illegalFlowEventCache = CacheBuilder.newBuilder().expireAfterWrite(this.illegalFlowEventRate, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<InetAddress, Optional<Instant>>(){

            public Optional<Instant> load(InetAddress key) throws Exception {
                return Optional.empty();
            }
        });
    }

    public long getIllegalFlowEventRate() {
        return this.illegalFlowEventRate;
    }

    public boolean getDnsLookupsEnabled() {
        return this.dnsLookupsEnabled;
    }

    public void setDnsLookupsEnabled(boolean dnsLookupsEnabled) {
        this.dnsLookupsEnabled = dnsLookupsEnabled;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("Threads must be >= 1");
        }
        this.threads = threads;
    }

    protected CompletableFuture<?> transmit(RecordProvider packet, InetSocketAddress remoteAddress) {
        CompletableFuture<CompletableFuture[]> futureOfFutures = CompletableFuture.supplyAsync(() -> (CompletableFuture[])packet.getRecords().map(record -> {
            CompletableFuture future = new CompletableFuture();
            Timer.Context timerContext = this.recordEnrichmentTimer.time();
            RecordEnricher recordEnricher = new RecordEnricher(this.dnsResolver, this.getDnsLookupsEnabled());
            recordEnricher.enrich((Iterable<Value<?>>)record).whenComplete((enrichment, ex) -> {
                timerContext.close();
                if (ex != null) {
                    future.completeExceptionally((Throwable)ex);
                    return;
                }
                Runnable dispatch = () -> {
                    byte[] flowMessage = new byte[]{};
                    try {
                        flowMessage = this.buildMessage((Iterable<Value<?>>)record, (RecordEnrichment)enrichment);
                    }
                    catch (IllegalFlowException e) {
                        Optional instant = (Optional)this.illegalFlowEventCache.getUnchecked((Object)remoteAddress.getAddress());
                        if (!instant.isPresent() || Duration.between((Temporal)instant.get(), Instant.now()).getSeconds() > this.getIllegalFlowEventRate()) {
                            this.illegalFlowEventCache.put((Object)remoteAddress.getAddress(), Optional.of(Instant.now()));
                            this.eventForwarder.sendNow(new EventBuilder().setUei(ILLEGAL_FLOW_EVENT_UEI).setTime(new Date()).setSource(this.getName()).setInterface(remoteAddress.getAddress()).setDistPoller(this.identity.getId()).addParam("monitoringSystemId", this.identity.getId()).addParam("monitoringSystemLocation", this.identity.getLocation()).setParam("cause", e.getMessage()).setParam("protocol", this.protocol.name()).setParam("illegalFlowEventRate", (int)this.getIllegalFlowEventRate()).getEvent());
                            LOG.warn("Illegal flow detected from exporter {}", (Object)remoteAddress.getAddress(), (Object)e);
                        }
                        return;
                    }
                    TelemetryMessage msg = new TelemetryMessage(remoteAddress, ByteBuffer.wrap(flowMessage));
                    this.dispatcher.send((Message)msg).whenComplete((b, exx) -> {
                        if (exx != null) {
                            future.completeExceptionally((Throwable)exx);
                            return;
                        }
                        future.complete(b);
                    });
                    this.recordsDispatched.mark();
                };
                if (Boolean.TRUE.equals(this.isParserThread.get())) {
                    dispatch.run();
                } else {
                    this.executor.execute(dispatch);
                }
            });
            return future;
        }).toArray(CompletableFuture[]::new), this.executor);
        CompletableFuture future = new CompletableFuture();
        futureOfFutures.whenComplete((futures, ex) -> {
            if (ex != null) {
                LOG.warn("Error preparing records for dispatch.", ex);
                future.completeExceptionally((Throwable)ex);
                return;
            }
            CompletableFuture.allOf(futures).whenComplete((any, exx) -> {
                if (exx != null) {
                    LOG.warn("One or more of the records were not successfully dispatched.", exx);
                    future.completeExceptionally((Throwable)exx);
                    return;
                }
                future.complete(any);
            });
        });
        return future;
    }

    protected abstract byte[] buildMessage(Iterable<Value<?>> var1, RecordEnrichment var2) throws IllegalFlowException;

    protected void detectClockSkew(long packetTimestampMs, InetAddress remoteAddress) {
        Optional instant;
        long deltaMs;
        if (!(this.getMaxClockSkew() <= 0L || (deltaMs = Math.abs(packetTimestampMs - System.currentTimeMillis())) <= this.getMaxClockSkew() * 1000L || (instant = (Optional)this.clockSkewEventCache.getUnchecked((Object)remoteAddress)).isPresent() && Duration.between((Temporal)instant.get(), Instant.now()).getSeconds() <= this.getClockSkewEventRate())) {
            this.clockSkewEventCache.put((Object)remoteAddress, Optional.of(Instant.now()));
            this.eventForwarder.sendNow(new EventBuilder().setUei(CLOCK_SKEW_EVENT_UEI).setTime(new Date()).setSource(this.getName()).setInterface(remoteAddress).setDistPoller(this.identity.getId()).addParam("monitoringSystemId", this.identity.getId()).addParam("monitoringSystemLocation", this.identity.getLocation()).setParam("delta", (int)deltaMs).setParam("clockSkewEventRate", (int)this.getClockSkewEventRate()).setParam("maxClockSkew", (int)this.getMaxClockSkew()).getEvent());
        }
    }
}

