/*
 * Decompiled with CFR 0.152.
 */
package rpc.core;

import ndr.NdrException;
import ndr.NdrObject;
import ndr.NetworkDataRepresentation;
import rpc.core.PresentationSyntax;

public class PresentationResult
extends NdrObject {
    public static final int ACCEPTANCE = 0;
    public static final int USER_REJECTION = 1;
    public static final int PROVIDER_REJECTION = 2;
    public static final int REASON_NOT_SPECIFIED = 0;
    public static final int ABSTRACT_SYNTAX_NOT_SUPPORTED = 1;
    public static final int PROPOSED_TRANSFER_SYNTAXES_NOT_SUPPORTED = 2;
    public static final int LOCAL_LIMIT_EXCEEDED = 3;
    public int result;
    public int reason;
    public PresentationSyntax transferSyntax;

    public PresentationResult() {
        this(0, 0, new PresentationSyntax("8a885d04-1ceb-11c9-9fe8-08002b104860:2.0"));
    }

    public PresentationResult(PresentationSyntax transferSyntax) {
        this(0, 0, transferSyntax);
    }

    public PresentationResult(int result, int reason) {
        this(result, reason, null);
    }

    public PresentationResult(int result, int reason, PresentationSyntax transferSyntax) {
        this.result = result;
        this.reason = reason;
        this.transferSyntax = transferSyntax;
    }

    @Override
    public void read(NetworkDataRepresentation ndr) {
        ndr.getBuffer().align(4);
        this.result = ndr.readUnsignedShort();
        this.reason = ndr.readUnsignedShort();
        this.transferSyntax = new PresentationSyntax();
        try {
            this.transferSyntax.decode(ndr, ndr.getBuffer());
        }
        catch (NdrException ndrException) {
            // empty catch block
        }
    }

    @Override
    public void write(NetworkDataRepresentation ndr) {
        ndr.getBuffer().align(4, (byte)0);
        ndr.writeUnsignedShort(this.result);
        ndr.writeUnsignedShort(this.reason);
        if (this.transferSyntax != null) {
            try {
                this.transferSyntax.encode(ndr, ndr.getBuffer());
            }
            catch (NdrException ndrException) {
                // empty catch block
            }
        }
    }
}

