/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import java.net.MalformedURLException;
import jcifs.CIFSContext;
import jcifs.SmbPipeHandle;
import jcifs.SmbPipeResource;
import jcifs.internal.smb1.com.SmbComNTCreateAndX;
import jcifs.internal.smb1.com.SmbComNTCreateAndXResponse;
import jcifs.smb.SmbException;
import jcifs.smb.SmbFile;
import jcifs.smb.SmbPipeHandleImpl;

public class SmbNamedPipe
extends SmbFile
implements SmbPipeResource {
    private final int pipeType;

    public SmbNamedPipe(String url, int pipeType, boolean unshared, CIFSContext tc) throws MalformedURLException {
        super(url, tc);
        this.pipeType = pipeType;
        this.setNonPooled(unshared);
        if (!this.getLocator().isIPC()) {
            throw new MalformedURLException("Named pipes are only valid on IPC$");
        }
        this.fileLocator.updateType(16);
    }

    public SmbNamedPipe(String url, int pipeType, CIFSContext tc) throws MalformedURLException {
        this(url, pipeType, (pipeType & 0x800) != 0, tc);
    }

    @Override
    protected void customizeCreate(SmbComNTCreateAndX request, SmbComNTCreateAndXResponse response) {
        request.addFlags0(22);
        response.setExtended(true);
    }

    @Override
    public int getType() throws SmbException {
        return 16;
    }

    @Override
    public int getPipeType() {
        return this.pipeType;
    }

    @Override
    public SmbPipeHandle openPipe() {
        return new SmbPipeHandleImpl(this);
    }
}

