/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.net.InetAddress;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.BmpParser;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.Header;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.Packet;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bgp.packets.Capability;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerFlags;
import org.opennms.netmgt.telemetry.protocols.bmp.parser.proto.bmp.PeerInfo;

public class OpenPacket
implements Packet {
    public final Header header;
    public final int version;
    public final int as;
    public final int holdTime;
    public final InetAddress id;
    public final List<Parameter> parameters;
    public final List<Capability> capabilities;

    public OpenPacket(Header header, ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) {
        this.header = Objects.requireNonNull(header);
        this.version = BufferUtils.uint8((ByteBuf)buffer);
        this.as = BufferUtils.uint16((ByteBuf)buffer);
        this.holdTime = BufferUtils.uint16((ByteBuf)buffer);
        this.id = InetAddressUtils.getInetAddress((byte[])BufferUtils.bytes((ByteBuf)buffer, (int)4));
        int parametersLength = BufferUtils.uint8((ByteBuf)buffer);
        this.parameters = BufferUtils.repeatRemaining((ByteBuf)BufferUtils.slice((ByteBuf)buffer, (int)parametersLength), x$0 -> new Parameter(x$0));
        this.capabilities = this.parameters.stream().filter(p -> p.type == 2).flatMap(p -> BufferUtils.repeatRemaining((ByteBuf)BufferUtils.slice((ByteBuf)p.value, (int)p.length), Capability::new).stream()).collect(Collectors.toList());
    }

    @Override
    public void accept(Packet.Visitor visitor) {
        visitor.visit(this);
    }

    public static Optional<OpenPacket> parse(ByteBuf buffer, PeerFlags flags, Optional<PeerInfo> peerInfo) throws InvalidPacketException {
        Header header = new Header(buffer);
        if (header.type != Header.Type.OPEN) {
            BmpParser.RATE_LIMITED_LOG.debug("Expected Open Message, got: {}", (Object)header.type);
            BufferUtils.skip((ByteBuf)buffer, (int)(header.length - 19));
            return Optional.empty();
        }
        return Optional.of(new OpenPacket(header, BufferUtils.slice((ByteBuf)buffer, (int)(header.length - 19)), flags, peerInfo));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("version", this.version).add("as", this.as).add("holdTime", this.holdTime).add("id", (Object)this.id).toString();
    }

    public static class Parameter {
        final int type;
        final int length;
        final ByteBuf value;

        private Parameter(ByteBuf buffer) {
            this.type = BufferUtils.uint8((ByteBuf)buffer);
            this.length = BufferUtils.uint8((ByteBuf)buffer);
            this.value = BufferUtils.slice((ByteBuf)buffer, (int)this.length);
        }

        public int getType() {
            return this.type;
        }

        public int getLength() {
            return this.length;
        }

        public ByteBuf getValue() {
            return this.value;
        }
    }
}

