/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.vmware.VmwareServer;
import org.opennms.netmgt.dao.VmwareConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.support.AbstractServiceMonitor;
import org.opennms.netmgt.provision.service.vmware.VmwareImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVmwareMonitor
extends AbstractServiceMonitor {
    private final Logger logger = LoggerFactory.getLogger(AbstractVmwareMonitor.class);
    private NodeDao m_nodeDao = null;
    private VmwareConfigDao m_vmwareConfigDao = null;

    public Map<String, Object> getRuntimeAttributes(MonitoredService svc, Map<String, Object> parameters) {
        OnmsNode onmsNode;
        if (this.m_nodeDao == null) {
            this.m_nodeDao = (NodeDao)BeanUtils.getBean((String)"daoContext", (String)"nodeDao", NodeDao.class);
        }
        if (this.m_vmwareConfigDao == null) {
            this.m_vmwareConfigDao = (VmwareConfigDao)BeanUtils.getBean((String)"daoContext", (String)"vmwareConfigDao", VmwareConfigDao.class);
        }
        if ((onmsNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(svc.getNodeId()))) == null) {
            throw new IllegalArgumentException("No node found with ID: " + svc.getNodeId());
        }
        String vmwareManagementServer = VmwareImporter.getManagementServer(onmsNode);
        String vmwareManagedEntityType = VmwareImporter.getManagedEntityType(onmsNode);
        String vmwareManagedObjectId = onmsNode.getForeignId();
        String vmwareMangementServerUsername = null;
        String vmwareMangementServerPassword = null;
        Map<String, VmwareServer> serverMap = this.m_vmwareConfigDao.getServerMap();
        if (serverMap == null) {
            this.logger.error("Error getting vmware-config.xml's server map.");
        } else {
            VmwareServer vmwareServer = serverMap.get(vmwareManagementServer);
            if (vmwareServer == null) {
                this.logger.error("Error getting credentials for VMware management server '{}'.", (Object)vmwareManagementServer);
            } else {
                vmwareMangementServerUsername = vmwareServer.getUsername();
                vmwareMangementServerPassword = vmwareServer.getPassword();
            }
        }
        return new ImmutableMap.Builder().put((Object)"managementServer", (Object)vmwareManagementServer).put((Object)"managedEntityType", (Object)vmwareManagedEntityType).put((Object)"managedObjectId", (Object)vmwareManagedObjectId).put((Object)"managementServerUsername", (Object)vmwareMangementServerUsername).put((Object)"managementServerPassword", (Object)vmwareMangementServerPassword).build();
    }
}

