/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.common.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.IpV4;

public class ExtendedSocketIpv4
implements FlowData {
    public final long protocol;
    public final IpV4 local_ip;
    public final IpV4 remote_ip;
    public final long local_port;
    public final long remote_port;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("protocol", this.protocol).add("local_ip", (Object)this.local_ip).add("remote_ip", (Object)this.remote_ip).add("local_port", this.local_port).add("remote_port", this.remote_port).toString();
    }

    public ExtendedSocketIpv4(ByteBuffer buffer) throws InvalidPacketException {
        this.protocol = BufferUtils.uint32((ByteBuffer)buffer);
        this.local_ip = new IpV4(buffer);
        this.remote_ip = new IpV4(buffer);
        this.local_port = BufferUtils.uint32((ByteBuffer)buffer);
        this.remote_port = BufferUtils.uint32((ByteBuffer)buffer);
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64("protocol", this.protocol);
        bsonWriter.writeName("local_ip");
        this.local_ip.writeBson(bsonWriter, enr);
        bsonWriter.writeName("remote_ip");
        this.remote_ip.writeBson(bsonWriter, enr);
        bsonWriter.writeInt64("local_port", this.local_port);
        bsonWriter.writeInt64("remote_port", this.remote_port);
        bsonWriter.writeEndDocument();
    }

    @Override
    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
        this.local_ip.visit(visitor);
        this.remote_ip.visit(visitor);
    }
}

