/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.registry.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.netmgt.provision.ServiceDetector;
import org.opennms.netmgt.provision.ServiceDetectorFactory;
import org.opennms.netmgt.provision.detector.registry.api.ServiceDetectorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceDetectorRegistryImpl
implements ServiceDetectorRegistry,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDetectorRegistryImpl.class);
    @Autowired(required=false)
    ServiceRegistry m_serviceRegistry;
    @Autowired(required=false)
    Set<ServiceDetectorFactory<?>> m_detectorFactories;
    private final Map<String, String> m_classNameByServiceName = new LinkedHashMap<String, String>();
    private final Map<String, ServiceDetectorFactory<? extends ServiceDetector>> m_factoriesByServiceName = new LinkedHashMap<String, ServiceDetectorFactory<? extends ServiceDetector>>();
    private final Map<String, ServiceDetectorFactory<? extends ServiceDetector>> m_factoriesByClassName = new LinkedHashMap<String, ServiceDetectorFactory<? extends ServiceDetector>>();

    public void afterPropertiesSet() throws Exception {
        if (this.m_detectorFactories != null) {
            for (ServiceDetectorFactory<?> factory : this.m_detectorFactories) {
                HashMap props = new HashMap();
                ServiceDetector detector = factory.createDetector();
                this.onBind(factory, props);
                this.addAllExtensions(Collections.singleton(detector), ServiceDetector.class);
            }
        }
    }

    private <T> void addAllExtensions(Collection<T> extensions, Class<?> ... extensionPoints) {
        if (extensions == null || extensions.isEmpty()) {
            LOG.info("Found NO Extensions for ExtensionPoints {}", (Object)Arrays.toString(extensionPoints));
            return;
        }
        for (T extension : extensions) {
            LOG.info("Register Extension {} for ExtensionPoints {}", extension, (Object)Arrays.toString(extensionPoints));
            this.m_serviceRegistry.register(extension, (Class[])extensionPoints);
        }
    }

    public synchronized void onBind(ServiceDetectorFactory factory, Map properties) {
        LOG.debug("bind called with {}: {}", (Object)factory, (Object)properties);
        if (factory != null) {
            String serviceName = ServiceDetectorRegistryImpl.getServiceName((ServiceDetectorFactory<? extends ServiceDetector>)factory);
            String className = factory.getDetectorClass().getCanonicalName();
            this.m_factoriesByServiceName.put(serviceName, (ServiceDetectorFactory<? extends ServiceDetector>)factory);
            this.m_factoriesByClassName.put(className, (ServiceDetectorFactory<? extends ServiceDetector>)factory);
            this.m_classNameByServiceName.put(serviceName, className);
        }
    }

    public synchronized void onUnbind(ServiceDetectorFactory factory, Map properties) {
        LOG.debug("unbind called with {}: {}", (Object)factory, (Object)properties);
        if (factory != null) {
            String serviceName = ServiceDetectorRegistryImpl.getServiceName((ServiceDetectorFactory<? extends ServiceDetector>)factory);
            String className = factory.getDetectorClass().getCanonicalName();
            this.m_factoriesByServiceName.remove(serviceName, factory);
            this.m_factoriesByClassName.remove(className, factory);
            this.m_classNameByServiceName.remove(serviceName, className);
        }
    }

    @Override
    public Map<String, String> getTypes() {
        return Collections.unmodifiableMap(this.m_classNameByServiceName);
    }

    @Override
    public Set<String> getServiceNames() {
        return Collections.unmodifiableSet(this.m_factoriesByServiceName.keySet());
    }

    @Override
    public ServiceDetector getDetectorByServiceName(String serviceName) {
        return this.getDetectorByServiceName(serviceName, Collections.emptyMap());
    }

    @Override
    public ServiceDetector getDetectorByServiceName(String serviceName, Map<String, String> properties) {
        return ServiceDetectorRegistryImpl.createDetector(this.m_factoriesByServiceName.get(serviceName), properties);
    }

    @Override
    public ServiceDetectorFactory<?> getDetectorFactoryByServiceName(String serviceName) {
        return this.m_factoriesByServiceName.get(serviceName);
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.unmodifiableSet(this.m_factoriesByClassName.keySet());
    }

    @Override
    public ServiceDetector getDetectorByClassName(String className) {
        return this.getDetectorByClassName(className, Collections.emptyMap());
    }

    @Override
    public ServiceDetector getDetectorByClassName(String className, Map<String, String> properties) {
        return ServiceDetectorRegistryImpl.createDetector(this.m_factoriesByClassName.get(className), properties);
    }

    @Override
    public ServiceDetectorFactory<?> getDetectorFactoryByClassName(String className) {
        return this.m_factoriesByClassName.get(className);
    }

    private static ServiceDetector createDetector(ServiceDetectorFactory<? extends ServiceDetector> factory, Map<String, String> properties) {
        if (factory == null) {
            return null;
        }
        ServiceDetector detector = factory.createDetector();
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)detector);
        wrapper.setPropertyValues(properties);
        return detector;
    }

    private static String getServiceName(ServiceDetectorFactory<? extends ServiceDetector> factory) {
        return factory.createDetector().getServiceName();
    }
}

