/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.Array;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.Address;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.SampleRecord;

public class SampleDatagramV5 {
    public final Address agent_address;
    public final long sub_agent_id;
    public final long sequence_number;
    public final long uptime;
    public final Array<SampleRecord> samples;

    public SampleDatagramV5(ByteBuffer buffer) throws InvalidPacketException {
        this.agent_address = new Address(buffer);
        this.sub_agent_id = BufferUtils.uint32((ByteBuffer)buffer);
        this.sequence_number = BufferUtils.uint32((ByteBuffer)buffer);
        this.uptime = BufferUtils.uint32((ByteBuffer)buffer);
        this.samples = new Array<Object>(buffer, Optional.empty(), SampleRecord::new);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("agent_address", (Object)this.agent_address).add("sub_agent_id", this.sub_agent_id).add("sequence_number", this.sequence_number).add("uptime", this.uptime).add("samples", this.samples).toString();
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeName("agent_address");
        this.agent_address.writeBson(bsonWriter);
        bsonWriter.writeInt64("sub_agent_id", this.sub_agent_id);
        bsonWriter.writeInt64("sequence_number", this.sequence_number);
        bsonWriter.writeInt64("uptime", this.uptime);
        bsonWriter.writeStartArray("samples");
        for (SampleRecord sampleRecord : this.samples) {
            sampleRecord.writeBson(bsonWriter);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeEndDocument();
    }
}

