/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.Array;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.Mac;

public class HostAdapter {
    public final long ifIndex;
    public final Array<Mac> mac_address;

    public HostAdapter(ByteBuffer buffer) throws InvalidPacketException {
        this.ifIndex = BufferUtils.uint32((ByteBuffer)buffer);
        this.mac_address = new Array<Object>(buffer, Optional.empty(), Mac::new);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ifIndex", this.ifIndex).add("mac_address", this.mac_address).toString();
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        bsonWriter.writeInt64(this.ifIndex);
        bsonWriter.writeStartArray("mac_address");
        for (Mac mac : this.mac_address) {
            mac.writeBson(bsonWriter);
        }
        bsonWriter.writeEndArray();
        bsonWriter.writeEndDocument();
    }
}

