/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;

public enum AsPathSegmentType {
    AS_SET(1),
    AS_SEQUENCE(2);

    public final int value;

    private AsPathSegmentType(int value) {
        this.value = value;
    }

    public static AsPathSegmentType from(ByteBuffer buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuffer)buffer);
        switch (value) {
            case 1: {
                return AS_SET;
            }
            case 2: {
                return AS_SEQUENCE;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeInt32("value", this.value);
    }
}

