/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.sflow.proto.flows;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.sflow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.AddressType;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.IpV4;
import org.opennms.netmgt.telemetry.listeners.sflow.proto.flows.IpV6;

public class Address {
    public final AddressType type;
    public final IpV4 ipV4;
    public final IpV6 ipV6;

    public Address(ByteBuffer buffer) throws InvalidPacketException {
        this.type = AddressType.from(buffer);
        switch (this.type) {
            case IP_V4: {
                this.ipV4 = new IpV4(buffer);
                this.ipV6 = null;
                break;
            }
            case IP_V6: {
                this.ipV4 = null;
                this.ipV6 = new IpV6(buffer);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("ipV4", (Object)this.ipV4).add("ipV6", (Object)this.ipV6).toString();
    }

    public void writeBson(BsonWriter bsonWriter) {
        bsonWriter.writeStartDocument();
        switch (this.type) {
            case IP_V4: {
                bsonWriter.writeName("ipv4");
                this.ipV4.writeBson(bsonWriter);
                break;
            }
            case IP_V6: {
                bsonWriter.writeName("ipv6");
                this.ipV6.writeBson(bsonWriter);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        bsonWriter.writeEndDocument();
    }
}

