/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.netmgt.telemetry.listeners.api.Listener;
import org.opennms.netmgt.telemetry.listeners.api.TelemetryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpListener
implements Listener {
    private static final Logger LOG = LoggerFactory.getLogger(UdpListener.class);
    private AsyncDispatcher<TelemetryMessage> dispatcher;
    private String name;
    private EventLoopGroup bossGroup;
    private ChannelFuture future;
    private String host = null;
    private int port = 50000;
    private int maxPacketSize = 8096;

    public void start() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        InetSocketAddress address = this.host != null ? SocketUtils.socketAddress((String)this.host, (int)this.port) : new InetSocketAddress(this.port);
        Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.bossGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_RCVBUF, (Object)Integer.MAX_VALUE)).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.maxPacketSize))).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

            protected void initChannel(DatagramChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new MessageToMessageDecoder<DatagramPacket>(){

                    protected void decode(ChannelHandlerContext ctx, DatagramPacket packet, List<Object> out) throws Exception {
                        ByteBuffer buffer = UdpListener.wrapContentsWithNioByteBuffer(packet);
                        TelemetryMessage msg = new TelemetryMessage((InetSocketAddress)packet.sender(), buffer);
                        CompletableFuture future = UdpListener.this.dispatcher.send((Message)msg);
                        packet.retain();
                        future.whenComplete((res, ex) -> packet.release());
                    }
                }});
            }
        });
        this.future = b.bind((SocketAddress)address).await();
    }

    public void stop() throws InterruptedException {
        LOG.info("Closing channel...");
        ChannelFuture cf = this.future.channel().closeFuture();
        LOG.info("Closing boss group...");
        this.bossGroup.shutdownGracefully().sync();
        cf.sync();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public String getName() {
        return this.name;
    }

    public void setDispatcher(AsyncDispatcher<TelemetryMessage> dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected static ByteBuffer wrapContentsWithNioByteBuffer(DatagramPacket packet) {
        int offset;
        byte[] array;
        ByteBuf content = (ByteBuf)packet.content();
        int length = content.readableBytes();
        if (content.hasArray()) {
            array = content.array();
            offset = content.arrayOffset() + content.readerIndex();
        } else {
            array = new byte[length];
            content.getBytes(content.readerIndex(), array, 0, length);
            offset = 0;
        }
        return ByteBuffer.wrap(array, offset, length);
    }
}

