/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.netflow9.proto;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.listeners.api.utils.BufferUtils;
import org.opennms.netmgt.telemetry.listeners.flow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.flow.ie.Value;
import org.opennms.netmgt.telemetry.listeners.flow.netflow9.proto.DataSet;
import org.opennms.netmgt.telemetry.listeners.flow.netflow9.proto.Record;
import org.opennms.netmgt.telemetry.listeners.flow.netflow9.proto.ScopeFieldSpecifier;
import org.opennms.netmgt.telemetry.listeners.flow.session.Field;
import org.opennms.netmgt.telemetry.listeners.flow.session.Session;
import org.opennms.netmgt.telemetry.listeners.flow.session.Template;

public final class DataRecord
implements Record {
    public final DataSet set;
    public final Template template;
    public final List<Value<?>> scopes;
    public final List<Value<?>> fields;
    public final List<Value<?>> options;

    public DataRecord(DataSet set, Session.Resolver resolver, Template template, ByteBuffer buffer) throws InvalidPacketException {
        this.set = Objects.requireNonNull(set);
        this.template = Objects.requireNonNull(template);
        ArrayList scopes = new ArrayList(this.template.scopes.size());
        for (Field field : template.scopes) {
            scopes.add(field.parse(resolver, BufferUtils.slice((ByteBuffer)buffer, (int)field.length())));
        }
        ArrayList fields = new ArrayList(this.template.fields.size());
        for (Field field : template.fields) {
            fields.add(field.parse(resolver, BufferUtils.slice((ByteBuffer)buffer, (int)field.length())));
        }
        this.scopes = Collections.unmodifiableList(scopes);
        this.fields = Collections.unmodifiableList(fields);
        this.options = resolver.lookupOptions(ScopeFieldSpecifier.buildScopeValues(this));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fields", this.fields).toString();
    }
}

