/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.opennms.netmgt.telemetry.listeners.flow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.FlowSet;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.FlowSetHeader;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.Packet;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.TemplateRecord;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.TemplateRecordHeader;

public class TemplateSet
extends FlowSet<TemplateRecord> {
    public final List<TemplateRecord> records;

    public TemplateSet(Packet packet, FlowSetHeader header, ByteBuffer buffer) throws InvalidPacketException {
        super(packet, header);
        LinkedList<TemplateRecord> records = new LinkedList<TemplateRecord>();
        while (buffer.remaining() >= 4) {
            TemplateRecordHeader recordHeader = new TemplateRecordHeader(buffer);
            records.add(new TemplateRecord(recordHeader, buffer));
        }
        if (records.size() == 0) {
            throw new InvalidPacketException(buffer, "Empty set", new Object[0]);
        }
        this.records = Collections.unmodifiableList(records);
    }

    @Override
    public Iterator<TemplateRecord> iterator() {
        return this.records.iterator();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("header", (Object)this.header).add("records", this.records).toString();
    }
}

