/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.flow.ipfix;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.listeners.flow.InvalidPacketException;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.Header;
import org.opennms.netmgt.telemetry.listeners.flow.ipfix.proto.Packet;
import org.opennms.netmgt.telemetry.listeners.flow.session.Session;

public class TcpPacketDecoder
extends ByteToMessageDecoder {
    private final InetSocketAddress senderAddress;
    private final InetSocketAddress recipientAddress;
    private final Session session;

    public TcpPacketDecoder(InetSocketAddress senderAddress, InetSocketAddress recipientAddress, Session session) {
        this.senderAddress = Objects.requireNonNull(senderAddress);
        this.recipientAddress = Objects.requireNonNull(recipientAddress);
        this.session = Objects.requireNonNull(session);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Object decoded = this.decode(ctx, in);
        if (decoded != null) {
            out.add(decoded);
        }
    }

    private Object decode(ChannelHandlerContext ctx, ByteBuf in) throws InvalidPacketException {
        in.markReaderIndex();
        if (in.readableBytes() < 16) {
            in.resetReaderIndex();
            return null;
        }
        ByteBuffer headerBuffer = in.readSlice(16).nioBuffer();
        Header header = new Header(headerBuffer);
        if (in.readableBytes() < header.length - 16) {
            in.resetReaderIndex();
            return null;
        }
        ByteBuffer payloadBuffer = in.readSlice(header.length - 16).nioBuffer();
        Packet packet = new Packet(this.session, this.senderAddress, header, payloadBuffer);
        return new DefaultAddressedEnvelope((Object)packet, (SocketAddress)this.recipientAddress, (SocketAddress)this.senderAddress);
    }
}

