/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.minion.heartbeat.consumer;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.minion.heartbeat.common.HeartbeatModule;
import org.opennms.minion.heartbeat.common.MinionIdentityDTO;
import org.opennms.netmgt.dao.api.MinionDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.events.api.EventSubscriptionService;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.minion.OnmsMinion;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.foreignsource.ForeignSource;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.transaction.annotation.Transactional;

public class HeartbeatConsumer
implements MessageConsumer<MinionIdentityDTO, MinionIdentityDTO>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(HeartbeatConsumer.class);
    private static final boolean PROVISIONING = Boolean.valueOf(System.getProperty("opennms.minion.provisioning", "true"));
    private static final String PROVISIONING_FOREIGN_SOURCE_PATTERN = System.getProperty("opennms.minion.provisioning.foreignSourcePattern", "Minions");
    private static final String MINION_INTERFACE = "127.0.0.1";
    private static final HeartbeatModule heartbeatModule = new HeartbeatModule();
    @Autowired
    private MinionDao minionDao;
    @Autowired
    private MessageConsumerManager messageConsumerManager;
    @Autowired
    @Qualifier(value="deployed")
    private ForeignSourceRepository deployedForeignSourceRepository;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy eventProxy;
    @Autowired
    @Qualifier(value="eventSubscriptionService")
    private EventSubscriptionService eventSubscriptionService;

    @Transactional
    public void handleMessage(MinionIdentityDTO minionHandle) {
        LOG.info("Received heartbeat for Minion with id: {} at location: {}", (Object)minionHandle.getId(), (Object)minionHandle.getLocation());
        OnmsMinion minion = this.minionDao.findById(minionHandle.getId());
        if (minion == null) {
            minion = new OnmsMinion();
            minion.setId(minionHandle.getId());
            minion.setLocation(null);
        }
        String prevLocation = minion.getLocation();
        String nextLocation = minionHandle.getLocation();
        minion.setLocation(minionHandle.getLocation());
        this.provision(minion, prevLocation, nextLocation);
        if (minionHandle.getTimestamp() == null) {
            minion.setLastUpdated(new Date());
            LOG.info("Received heartbeat without a timestamp: {}", (Object)minionHandle);
        } else if (minion.getLastUpdated() == null) {
            minion.setLastUpdated(minionHandle.getTimestamp());
        } else if (minionHandle.getTimestamp().after(minion.getLastUpdated())) {
            minion.setLastUpdated(minionHandle.getTimestamp());
        } else {
            LOG.info("Ignoring stale timestamp from heartbeat: {}", (Object)minionHandle);
        }
        this.minionDao.saveOrUpdate((Object)minion);
        if (prevLocation == null) {
            EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/monitoringSystemAdded", "OpenNMS.Minion.Heartbeat");
            eventBuilder.addParam("monitoringSystemType", "Minion");
            eventBuilder.addParam("monitoringSystemId", minionHandle.getId());
            eventBuilder.addParam("monitoringSystemLocation", nextLocation);
            try {
                this.eventProxy.send(eventBuilder.getEvent());
            }
            catch (EventProxyException e) {
                throw new DataAccessResourceFailureException("Unable to send event", (Throwable)e);
            }
        }
        if (!prevLocation.equals(nextLocation)) {
            EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/monitoringSystemLocationChanged", "OpenNMS.Minion.Heartbeat");
            eventBuilder.addParam("monitoringSystemType", "Minion");
            eventBuilder.addParam("monitoringSystemId", minionHandle.getId());
            eventBuilder.addParam("monitoringSystemPreviousLocation", prevLocation);
            eventBuilder.addParam("monitoringSystemLocation", nextLocation);
            try {
                this.eventProxy.send(eventBuilder.getEvent());
            }
            catch (EventProxyException e) {
                throw new DataAccessResourceFailureException("Unable to send event", (Throwable)e);
            }
        }
    }

    private void provision(OnmsMinion minion, String prevLocation, String nextLocation) {
        RequisitionInterface requisitionInterface;
        RequisitionNode requisitionNode;
        Requisition nextRequisition;
        Requisition prevRequisition;
        if (!PROVISIONING) {
            return;
        }
        if (!this.eventSubscriptionService.hasEventListener("uei.opennms.org/internal/importer/reloadImport")) {
            return;
        }
        String prevForeignSource = String.format(PROVISIONING_FOREIGN_SOURCE_PATTERN, prevLocation);
        String nextForeignSource = String.format(PROVISIONING_FOREIGN_SOURCE_PATTERN, nextLocation);
        HashSet alteredForeignSources = Sets.newHashSet();
        if (!Objects.equals(prevForeignSource, nextForeignSource) && (prevRequisition = this.deployedForeignSourceRepository.getRequisition(prevForeignSource)) != null && prevRequisition.getNode(minion.getId()) != null) {
            prevRequisition.deleteNode(minion.getId());
            prevRequisition.updateDateStamp();
            this.deployedForeignSourceRepository.save(prevRequisition);
            this.deployedForeignSourceRepository.flush();
            alteredForeignSources.add(prevForeignSource);
        }
        if ((nextRequisition = this.deployedForeignSourceRepository.getRequisition(nextForeignSource)) == null) {
            nextRequisition = new Requisition(nextForeignSource);
            nextRequisition.updateDateStamp();
            this.deployedForeignSourceRepository.save(nextRequisition);
            ForeignSource foreignSource = this.deployedForeignSourceRepository.getForeignSource(nextForeignSource);
            foreignSource.setDetectors(Collections.emptyList());
            foreignSource.setPolicies(Collections.emptyList());
            this.deployedForeignSourceRepository.save(foreignSource);
            alteredForeignSources.add(nextForeignSource);
        }
        if ((requisitionNode = nextRequisition.getNode(minion.getId())) == null) {
            requisitionInterface = new RequisitionInterface();
            requisitionInterface.setIpAddr(MINION_INTERFACE);
            HeartbeatConsumer.ensureServicesAreOnInterface(requisitionInterface);
            requisitionNode = new RequisitionNode();
            requisitionNode.setNodeLabel(minion.getId());
            requisitionNode.setForeignId(minion.getLabel() != null ? minion.getLabel() : minion.getId());
            requisitionNode.setLocation(minion.getLocation());
            requisitionNode.putInterface(requisitionInterface);
            nextRequisition.putNode(requisitionNode);
            nextRequisition.setDate(new Date());
            this.deployedForeignSourceRepository.save(nextRequisition);
            this.deployedForeignSourceRepository.flush();
            alteredForeignSources.add(nextForeignSource);
        } else {
            if (!prevLocation.equals(nextLocation)) {
                requisitionNode.setLocation(nextLocation);
            }
            if ((requisitionInterface = requisitionNode.getInterface(MINION_INTERFACE)) == null) {
                requisitionInterface = new RequisitionInterface();
                requisitionInterface.setIpAddr(MINION_INTERFACE);
                requisitionNode.putInterface(requisitionInterface);
            }
            if (HeartbeatConsumer.ensureServicesAreOnInterface(requisitionInterface)) {
                nextRequisition.setDate(new Date());
                this.deployedForeignSourceRepository.save(nextRequisition);
                this.deployedForeignSourceRepository.flush();
                alteredForeignSources.add(nextForeignSource);
            }
        }
        for (String alteredForeignSource : alteredForeignSources) {
            EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", "Web");
            eventBuilder.addParam("url", String.valueOf(this.deployedForeignSourceRepository.getRequisitionURL(alteredForeignSource)));
            try {
                this.eventProxy.send(eventBuilder.getEvent());
            }
            catch (EventProxyException e) {
                throw new DataAccessResourceFailureException("Unable to send event to import group " + alteredForeignSource, (Throwable)e);
            }
        }
    }

    private static boolean ensureServicesAreOnInterface(RequisitionInterface requisitionInterface) {
        ArrayList<RequisitionMonitoredService> minionServices = new ArrayList<RequisitionMonitoredService>();
        RequisitionMonitoredService heartbeatService = new RequisitionMonitoredService();
        heartbeatService.setServiceName("Minion-Heartbeat");
        minionServices.add(heartbeatService);
        RequisitionMonitoredService rpcService = new RequisitionMonitoredService();
        rpcService.setServiceName("Minion-RPC");
        minionServices.add(rpcService);
        RequisitionMonitoredService jmxService = new RequisitionMonitoredService();
        jmxService.setServiceName("JMX-Minion");
        minionServices.add(jmxService);
        boolean didAlterInterface = false;
        for (RequisitionMonitoredService svc : minionServices) {
            if (requisitionInterface.getMonitoredService(svc.getServiceName()) != null) continue;
            requisitionInterface.putMonitoredService(svc);
            didAlterInterface = true;
        }
        return didAlterInterface;
    }

    public void afterPropertiesSet() throws Exception {
        this.messageConsumerManager.registerConsumer((MessageConsumer)this);
    }

    public SinkModule<MinionIdentityDTO, MinionIdentityDTO> getModule() {
        return heartbeatModule;
    }
}

