/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.kafka.producer.collection;

import com.google.common.base.Strings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.opennms.features.kafka.producer.model.CollectionSetProtos;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSet;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CollectionSetMapper {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionSetMapper.class);
    @Autowired
    private NodeDao nodeDao;
    private final SessionUtils sessionUtils;

    public CollectionSetMapper(NodeDao nodeDao, SessionUtils sessionUtils) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public CollectionSetProtos.CollectionSet buildCollectionSetProtos(final CollectionSet collectionSet) {
        final CollectionSetProtos.CollectionSet.Builder builder = CollectionSetProtos.CollectionSet.newBuilder();
        collectionSet.visit(new CollectionSetVisitor(){
            CollectionSetProtos.CollectionSetResource.Builder collectionSetResourceBuilder;
            String lastGroupName = null;

            public void visitCollectionSet(CollectionSet set) {
            }

            public void visitResource(CollectionResource resource) {
                this.collectionSetResourceBuilder = CollectionSetProtos.CollectionSetResource.newBuilder();
                if (resource.getResourceTypeName().equals("node")) {
                    String nodeCriteria = CollectionSetMapper.this.getNodeCriteriaFromResource(resource);
                    CollectionSetProtos.NodeLevelResource.Builder nodeResourceBuilder = CollectionSetMapper.this.buildNodeLevelResourceForProto(nodeCriteria);
                    this.collectionSetResourceBuilder.setNode(nodeResourceBuilder);
                } else if (resource.getResourceTypeName().equals("if")) {
                    CollectionSetProtos.InterfaceLevelResource.Builder interfaceResourceBuilder = CollectionSetProtos.InterfaceLevelResource.newBuilder();
                    String nodeCriteria = CollectionSetMapper.this.getNodeCriteriaFromResource(resource);
                    if (!Strings.isNullOrEmpty((String)nodeCriteria)) {
                        CollectionSetProtos.NodeLevelResource.Builder nodeResourceBuilder = CollectionSetMapper.this.buildNodeLevelResourceForProto(nodeCriteria);
                        interfaceResourceBuilder.setNode(nodeResourceBuilder);
                        interfaceResourceBuilder.setInstance(resource.getInterfaceLabel());
                        this.collectionSetResourceBuilder.setInterface(interfaceResourceBuilder);
                    }
                } else if (resource.getResourceTypeName().equals("latency")) {
                    CollectionSetProtos.ResponseTimeResource.Builder responseTimeResource = CollectionSetMapper.this.buildResponseTimeResource(resource);
                    if (responseTimeResource != null) {
                        this.collectionSetResourceBuilder.setResponse(responseTimeResource);
                    }
                } else {
                    CollectionSetProtos.GenericTypeResource.Builder genericResourceBuilder = CollectionSetProtos.GenericTypeResource.newBuilder();
                    String nodeCriteria = CollectionSetMapper.this.getNodeCriteriaFromResource(resource);
                    if (!Strings.isNullOrEmpty((String)nodeCriteria)) {
                        CollectionSetProtos.NodeLevelResource.Builder nodeResourceBuilder = CollectionSetMapper.this.buildNodeLevelResourceForProto(nodeCriteria);
                        genericResourceBuilder.setNode(nodeResourceBuilder);
                    }
                    genericResourceBuilder.setType(resource.getResourceTypeName());
                    genericResourceBuilder.setInstance(resource.getInstance());
                    this.collectionSetResourceBuilder.setGeneric(genericResourceBuilder);
                }
            }

            public void visitGroup(AttributeGroup group) {
                this.lastGroupName = group.getName();
            }

            public void visitAttribute(CollectionAttribute attribute) {
                if (attribute.getType().equals((Object)AttributeType.STRING)) {
                    CollectionSetProtos.StringAttribute.Builder attributeBuilder = CollectionSetProtos.StringAttribute.newBuilder();
                    attributeBuilder.setValue(attribute.getStringValue());
                    attributeBuilder.setName(attribute.getName());
                    this.collectionSetResourceBuilder.addString(attributeBuilder);
                } else {
                    CollectionSetProtos.NumericAttribute.Builder attributeBuilder = CollectionSetProtos.NumericAttribute.newBuilder();
                    attributeBuilder.setGroup(this.lastGroupName);
                    attributeBuilder.setName(attribute.getName());
                    attributeBuilder.setValue(attribute.getNumericValue().doubleValue());
                    attributeBuilder.setType(attribute.getType() == AttributeType.GAUGE ? CollectionSetProtos.NumericAttribute.Type.GAUGE : CollectionSetProtos.NumericAttribute.Type.COUNTER);
                    this.collectionSetResourceBuilder.addNumeric(attributeBuilder);
                }
            }

            public void completeAttribute(CollectionAttribute attribute) {
            }

            public void completeGroup(AttributeGroup group) {
            }

            public void completeResource(CollectionResource resource) {
                builder.addResource(this.collectionSetResourceBuilder);
            }

            public void completeCollectionSet(CollectionSet set) {
                builder.setTimestamp(collectionSet.getCollectionTimestamp().getTime());
            }
        });
        return builder.build();
    }

    private String getNodeCriteriaFromResource(CollectionResource resource) {
        String nodeCriteria = null;
        if (resource.getParent() != null) {
            String[] resourcePathArray = resource.getParent().elements();
            if ("fs".equals(resourcePathArray[0]) && resourcePathArray.length == 3) {
                nodeCriteria = resourcePathArray[1] + ":" + resourcePathArray[2];
            } else if (this.checkNumeric(resourcePathArray[0])) {
                nodeCriteria = resourcePathArray[0];
            }
        }
        return nodeCriteria;
    }

    private CollectionSetProtos.ResponseTimeResource.Builder buildResponseTimeResource(CollectionResource resource) {
        String[] resourcePathArray;
        boolean validIp = false;
        if (resource.getParent() != null && resource.getParent().elements().length == 1) {
            resourcePathArray = resource.getParent().elements();
            validIp = this.checkForValidIpAddress(resourcePathArray[0]);
        }
        if (resource.getPath() != null && validIp) {
            resourcePathArray = resource.getPath().elements();
            CollectionSetProtos.ResponseTimeResource.Builder responseTimeResourceBuilder = CollectionSetProtos.ResponseTimeResource.newBuilder();
            if (resourcePathArray.length == 2) {
                responseTimeResourceBuilder.setLocation(resourcePathArray[0]);
                responseTimeResourceBuilder.setInstance(resourcePathArray[1]);
            } else if (resourcePathArray.length == 1) {
                responseTimeResourceBuilder.setInstance(resourcePathArray[0]);
            }
            return responseTimeResourceBuilder;
        }
        return null;
    }

    private boolean checkNumeric(String nodeCriteria) {
        try {
            Integer.parseInt(nodeCriteria);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private boolean checkForValidIpAddress(String resourcePath) {
        try {
            InetAddress.getByName(resourcePath);
            return true;
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public CollectionSetProtos.NodeLevelResource.Builder buildNodeLevelResourceForProto(String nodeCriteria) {
        CollectionSetProtos.NodeLevelResource.Builder nodeResourceBuilder = CollectionSetProtos.NodeLevelResource.newBuilder();
        this.sessionUtils.withReadOnlyTransaction(() -> {
            try {
                OnmsNode node = this.nodeDao.get(nodeCriteria);
                if (node != null) {
                    nodeResourceBuilder.setNodeId(node.getId().intValue());
                    nodeResourceBuilder.setNodeLabel(node.getLabel());
                    nodeResourceBuilder.setForeignId(node.getForeignId());
                    nodeResourceBuilder.setForeignSource(node.getForeignSource());
                    if (node.getLocation() != null) {
                        nodeResourceBuilder.setLocation(node.getLocation().getLocationName());
                    }
                }
            }
            catch (Exception e) {
                LOG.error("error while trying to match node from {}", (Object)nodeCriteria);
            }
            return null;
        });
        return nodeResourceBuilder;
    }
}

