/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.graphs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.opennms.features.jmxconfiggenerator.graphs.Report;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphConfigGenerator {
    private static Logger logger = LoggerFactory.getLogger(GraphConfigGenerator.class);

    public String generateSnmpGraph(Collection<Report> reports, String graphTemplate) {
        Velocity.init();
        VelocityContext context = new VelocityContext();
        context.put("reportsList", reports.iterator());
        context.put("reportsBody", reports.iterator());
        Template template = null;
        try {
            template = Velocity.getTemplate((String)graphTemplate);
        }
        catch (ResourceNotFoundException rnfe) {
            logger.debug("couldn't find the template:'{}'", (Object)rnfe.getMessage());
        }
        catch (ParseErrorException pee) {
            logger.debug("syntax error: problem parsing the template:'{}'", (Object)pee.getMessage());
        }
        catch (MethodInvocationException mie) {
            logger.debug("something invoked in the template threw an exception:'{}'", (Object)mie.getMessage());
        }
        catch (Exception e) {
            logger.debug("undefined exception:'{}'", (Object)e.getMessage());
        }
        StringWriter sw = new StringWriter();
        if (template != null) {
            template.merge((Context)context, (Writer)sw);
        }
        return sw.toString();
    }

    public String generateSnmpGraph(Collection<Report> reports) throws IOException {
        String jarInternTemplate = "graphTemplate.vm";
        VelocityEngine velocityEngine = new VelocityEngine();
        velocityEngine.setProperty("resource.loader", (Object)"classpath");
        velocityEngine.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        velocityEngine.init();
        String templatePath = jarInternTemplate;
        InputStream templateInputStream = this.getClass().getClassLoader().getResourceAsStream(templatePath);
        if (templateInputStream == null) {
            throw new IOException(String.format("Template file '%s' doesn't exist.", jarInternTemplate));
        }
        StringWriter templateWriter = new StringWriter();
        InputStreamReader templateReader = new InputStreamReader(templateInputStream);
        VelocityContext context = new VelocityContext();
        context.put("reportsList", reports.iterator());
        context.put("reportsBody", reports.iterator());
        Velocity.evaluate((Context)context, (Writer)templateWriter, (String)jarInternTemplate, (Reader)templateReader);
        return templateWriter.toString();
    }
}

