/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.webui.ui.mbeans;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.HierarchicalContainer;
import com.vaadin.event.ItemClickEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.jmxconfiggenerator.webui.data.JmxCollectionCloner;
import org.opennms.features.jmxconfiggenerator.webui.data.ModelChangeListener;
import org.opennms.features.jmxconfiggenerator.webui.data.ModelChangeNotifier;
import org.opennms.features.jmxconfiggenerator.webui.data.SelectableBeanItemContainer;
import org.opennms.features.jmxconfiggenerator.webui.data.SelectableItem;
import org.opennms.features.jmxconfiggenerator.webui.data.StringRenderer;
import org.opennms.features.jmxconfiggenerator.webui.data.UiModel;
import org.opennms.features.jmxconfiggenerator.webui.ui.ModelChangeRegistry;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MBeansItemStrategyHandler;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.MbeansHierarchicalContainer;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.NameProvider;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewState;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedEvent;
import org.opennms.features.jmxconfiggenerator.webui.ui.mbeans.ViewStateChangedListener;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Attrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompAttrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompMember;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxCollection;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

public class MBeansController
implements ModelChangeNotifier,
ViewStateChangedListener,
ModelChangeListener<UiModel>,
NameProvider {
    private final MbeansHierarchicalContainer mbeansContainer = new MbeansHierarchicalContainer(this);
    private final ModelChangeRegistry registry = new ModelChangeRegistry();
    private final Collection<ViewStateChangedListener> viewStateListener = new ArrayList<ViewStateChangedListener>();
    private final MBeansItemStrategyHandler itemStrategyHandler = new MBeansItemStrategyHandler();
    private Mbean currentlySelected = null;
    private ViewState currentState = ViewState.Init;
    private AttributesContainerCache<Attrib, Mbean> attribContainerCache = new AttributesContainerCache(Attrib.class, new AttributesContainerCache.AttributeCollector<Attrib, Mbean>(){

        @Override
        public List<Attrib> getAttributes(Mbean outer) {
            return outer.getAttrib();
        }
    });
    private AttributesContainerCache<CompAttrib, Mbean> compAttribContainerCache = new AttributesContainerCache(CompAttrib.class, new AttributesContainerCache.AttributeCollector<CompAttrib, Mbean>(){

        @Override
        public List<CompAttrib> getAttributes(Mbean outer) {
            return outer.getCompAttrib();
        }
    });
    private AttributesContainerCache<CompMember, CompAttrib> compMemberContainerCache = new AttributesContainerCache(CompMember.class, new AttributesContainerCache.AttributeCollector<CompMember, CompAttrib>(){

        @Override
        public List<CompMember> getAttributes(CompAttrib outer) {
            return outer.getCompMember();
        }
    });

    public void registerListener(Class clazz, ModelChangeListener listener) {
        this.registry.registerListener(clazz, listener);
    }

    public void notifyObservers(Class clazz, Object newModel) {
        this.registry.notifyObservers(clazz, newModel);
    }

    public MbeansHierarchicalContainer getMBeansHierarchicalContainer() {
        return this.mbeansContainer;
    }

    protected void updateView(ItemClickEvent event) {
        if (this.currentlySelected == event.getItemId()) {
            return;
        }
        this.currentlySelected = event.getItemId() instanceof Mbean ? (Mbean)event.getItemId() : null;
        this.registry.notifyObservers((Class)Item.class, (Object)event.getItem());
        this.registry.notifyObservers((Class)event.getItemId().getClass(), event.getItemId());
        this.setState(event.getItemId());
    }

    private ViewState getNextState(Object itemId) {
        if (itemId == null) {
            return ViewState.Init;
        }
        if (itemId instanceof Mbean) {
            return ViewState.LeafSelected;
        }
        if (!(itemId instanceof Mbean)) {
            return ViewState.NonLeafSelected;
        }
        return ViewState.Init;
    }

    private void setState(Object itemId) {
        ViewState nextState = this.getNextState(itemId);
        if (nextState == this.currentState) {
            return;
        }
        this.fireViewStateChanged(new ViewStateChangedEvent(this.currentState, nextState, this));
    }

    public void setItemProperties(Item item, Object itemId) {
        this.itemStrategyHandler.setItemProperties(item, itemId);
    }

    public StringRenderer getStringRenderer(Class<?> clazz) {
        return this.itemStrategyHandler.getStringRenderer(clazz);
    }

    @Override
    public void viewStateChanged(ViewStateChangedEvent event) {
        this.currentState = event.getNewState();
        if (event.getNewState() == ViewState.Init) {
            ((AttributesContainerCache)this.attribContainerCache).containerMap.clear();
            ((AttributesContainerCache)this.compAttribContainerCache).containerMap.clear();
            ((AttributesContainerCache)this.compMemberContainerCache).containerMap.clear();
        }
    }

    protected void addView(ViewStateChangedListener view) {
        this.viewStateListener.add(view);
    }

    @Override
    public void modelChanged(UiModel newModel) {
        this.fireViewStateChanged(new ViewStateChangedEvent(this.currentState, ViewState.Init, this));
    }

    protected void fireViewStateChanged(ViewState newState, Object source) {
        this.fireViewStateChanged(new ViewStateChangedEvent(this.currentState, newState, source));
    }

    private void fireViewStateChanged(ViewStateChangedEvent event) {
        for (ViewStateChangedListener listener : this.viewStateListener) {
            listener.viewStateChanged(event);
        }
    }

    void handleDeselect(HierarchicalContainer container, Object itemId) {
        this.handleSelectDeselect(container, container.getItem(itemId), itemId, false);
    }

    void handleSelect(HierarchicalContainer container, Object itemId) {
        this.handleSelectDeselect(container, container.getItem(itemId), itemId, true);
    }

    public void handleSelectDeselect(HierarchicalContainer container, Item item, Object itemId, boolean select) {
        this.itemStrategyHandler.getStrategy(itemId.getClass()).handleSelectDeselect(item, itemId, select);
        if (!container.hasChildren(itemId)) {
            return;
        }
        for (Object childItemId : container.getChildren(itemId)) {
            this.handleSelectDeselect(container, container.getItem(childItemId), childItemId, select);
        }
    }

    public void updateMBeanIcon() {
        this.itemStrategyHandler.getStrategy(Mbean.class).updateIcon(this.mbeansContainer.getItem(this.currentlySelected));
    }

    public SelectableBeanItemContainer<Attrib> getAttributeContainer(Mbean bean) {
        return this.attribContainerCache.getContainer(bean);
    }

    public void clearAttributesCache() {
        ((AttributesContainerCache)this.attribContainerCache).containerMap.clear();
    }

    protected void updateMBean() {
        this.itemStrategyHandler.getStrategy(Mbean.class).updateModel(this.mbeansContainer.getItem(this.currentlySelected), this.currentlySelected);
    }

    public SelectableBeanItemContainer<CompMember> getCompositeMemberContainer(CompAttrib attrib) {
        return this.compMemberContainerCache.getContainer(attrib);
    }

    public SelectableBeanItemContainer<CompAttrib> getCompositeAttributeContainer(Mbean mbean) {
        return this.compAttribContainerCache.getContainer(mbean);
    }

    @Override
    public Map<Object, String> getNames() {
        HashMap<Object, String> names = new HashMap<Object, String>();
        for (Mbean bean : this.mbeansContainer.getMBeans()) {
            for (Attrib att : bean.getAttrib()) {
                names.put(att, att.getAlias());
            }
            for (CompAttrib compAttrib : bean.getCompAttrib()) {
                for (CompMember compMember : compAttrib.getCompMember()) {
                    names.put(compMember, compMember.getAlias());
                }
            }
        }
        return names;
    }

    protected Mbean getSelectedMBean() {
        return this.currentlySelected;
    }

    public JmxDatacollectionConfig createJmxDataCollectionAccordingToSelection(UiModel uiModel) {
        JmxDatacollectionConfig clone = JmxCollectionCloner.clone(uiModel.getRawModel());
        List exportBeans = ((JmxCollection)clone.getJmxCollection().get(0)).getMbeans().getMbean();
        exportBeans.clear();
        Iterable<Mbean> selectedMbeans = MBeansController.getSelectedMbeans(this.getMBeansHierarchicalContainer());
        for (Mbean mbean : selectedMbeans) {
            Mbean exportBean = JmxCollectionCloner.clone(mbean);
            exportBean.getAttrib().clear();
            for (Attrib att : MBeansController.getSelectedAttributes(mbean, this.getAttributeContainer(mbean))) {
                exportBean.getAttrib().add(JmxCollectionCloner.clone(att));
            }
            if (!exportBean.getAttrib().isEmpty()) {
                exportBeans.add(exportBean);
            }
            exportBean.getCompAttrib().clear();
            for (CompAttrib compAtt : MBeansController.getSelectedCompositeAttributes(mbean, this.getCompositeAttributeContainer(mbean))) {
                CompAttrib cloneCompAtt = JmxCollectionCloner.clone(compAtt);
                cloneCompAtt.getCompMember().clear();
                for (CompMember compMember : MBeansController.getSelectedCompositeMembers(compAtt, this.getCompositeMemberContainer(compAtt))) {
                    cloneCompAtt.getCompMember().add(JmxCollectionCloner.clone(compMember));
                }
                if (cloneCompAtt.getCompMember().isEmpty()) continue;
                exportBean.getCompAttrib().add(cloneCompAtt);
            }
        }
        ((JmxCollection)clone.getJmxCollection().get(0)).setName(uiModel.getServiceName());
        return clone;
    }

    protected Iterable<Mbean> getSelectedMbeans() {
        return MBeansController.getSelectedMbeans(this.mbeansContainer);
    }

    protected Iterable<Attrib> getSelectedAttributes(Mbean mbean) {
        return MBeansController.getSelectedAttributes(mbean, this.getAttributeContainer(mbean));
    }

    protected Iterable<CompAttrib> getSelectedCompositeAttributes(Mbean mbean) {
        return MBeansController.getSelectedCompositeAttributes(mbean, this.getCompositeAttributeContainer(mbean));
    }

    protected Iterable<CompMember> getSelectedCompositeMembers(CompAttrib compAttrib) {
        return MBeansController.getSelectedCompositeMembers(compAttrib, this.getCompositeMemberContainer(compAttrib));
    }

    private static Iterable<Mbean> getSelectedMbeans(final MbeansHierarchicalContainer container) {
        return Iterables.filter(container.getMBeans(), (Predicate)new Predicate<Mbean>(){

            public boolean apply(Mbean bean) {
                Item item = container.getItem(bean);
                Property itemProperty = item.getItemProperty((Object)"selected");
                if (itemProperty != null && itemProperty.getValue() != null) {
                    return (Boolean)itemProperty.getValue();
                }
                return false;
            }
        });
    }

    private static Iterable<CompAttrib> getSelectedCompositeAttributes(Mbean mbean, final SelectableBeanItemContainer<CompAttrib> compAttribContainer) {
        if (AttributesContainerCache.NULL == compAttribContainer) {
            return mbean.getCompAttrib();
        }
        return Iterables.filter((Iterable)mbean.getCompAttrib(), (Predicate)new Predicate<CompAttrib>(){

            public boolean apply(CompAttrib compAtt) {
                return ((SelectableItem)compAttribContainer.getItem(compAtt)).isSelected();
            }
        });
    }

    private static Iterable<CompMember> getSelectedCompositeMembers(CompAttrib compAtt, final SelectableBeanItemContainer<CompMember> compMemberContainer) {
        if (AttributesContainerCache.NULL == compMemberContainer) {
            return compAtt.getCompMember();
        }
        return Iterables.filter((Iterable)compAtt.getCompMember(), (Predicate)new Predicate<CompMember>(){

            public boolean apply(CompMember compMember) {
                return ((SelectableItem)compMemberContainer.getItem(compMember)).isSelected();
            }
        });
    }

    private static Iterable<Attrib> getSelectedAttributes(Mbean mbean, final SelectableBeanItemContainer<Attrib> attributesContainer) {
        if (AttributesContainerCache.NULL == attributesContainer) {
            return mbean.getAttrib();
        }
        return Iterables.filter((Iterable)mbean.getAttrib(), (Predicate)new Predicate<Attrib>(){

            public boolean apply(Attrib attrib) {
                return ((SelectableItem)attributesContainer.getItem(attrib)).isSelected();
            }
        });
    }

    public static class AttributesContainerCache<ATTRIBUTETYPE, PARENTTYPE> {
        public static final SelectableBeanItemContainer NULL = new SelectableBeanItemContainer<Object>(Object.class);
        private final Map<PARENTTYPE, SelectableBeanItemContainer<ATTRIBUTETYPE>> containerMap = new HashMap<PARENTTYPE, SelectableBeanItemContainer<ATTRIBUTETYPE>>();
        private final Class<? super ATTRIBUTETYPE> type;
        private final AttributeCollector<ATTRIBUTETYPE, PARENTTYPE> attribCollector;

        private AttributesContainerCache(Class<? super ATTRIBUTETYPE> type, AttributeCollector<ATTRIBUTETYPE, PARENTTYPE> attribCollector) {
            this.type = type;
            this.attribCollector = attribCollector;
        }

        public SelectableBeanItemContainer<ATTRIBUTETYPE> getContainer(PARENTTYPE bean) {
            if (bean == null) {
                return NULL;
            }
            if (this.containerMap.get(bean) != null) {
                return this.containerMap.get(bean);
            }
            this.containerMap.put(bean, new SelectableBeanItemContainer<ATTRIBUTETYPE>(this.type));
            this.initContainer(this.containerMap.get(bean), bean);
            return this.containerMap.get(bean);
        }

        private void initContainer(SelectableBeanItemContainer<ATTRIBUTETYPE> container, PARENTTYPE bean) {
            for (ATTRIBUTETYPE att : this.attribCollector.getAttributes(bean)) {
                container.addItem(att);
            }
        }

        public static interface AttributeCollector<ATTRIBUTETYPE, PARENTTYPE> {
            public List<ATTRIBUTETYPE> getAttributes(PARENTTYPE var1);
        }
    }

    public static interface Callback {
        public Container getContainer();
    }
}

