/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira.commands;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.api.domain.CimIssueType;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.atlassian.jira.rest.client.api.domain.ServerInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.netmgt.ticketer.jira.Config;
import org.opennms.netmgt.ticketer.jira.JiraClientUtils;
import org.opennms.netmgt.ticketer.jira.JiraConnectionFactory;
import org.opennms.netmgt.ticketer.jira.JiraTicketerPlugin;

@Command(scope="opennms", name="jira-verify", description="Verifies the current configuration")
@org.apache.karaf.shell.commands.Command(scope="opennms", name="jira-verify", description="Verifies the current configuration")
@Service
public class VerifyCommand
extends OsgiCommandSupport
implements Action {
    private Config config = JiraTicketerPlugin.getConfig();
    @Option(name="-f", aliases={"--field"}, description="Verifies the existence of the defined field(s).", required=false, multiValued=true)
    String[] field;

    public Object execute() throws Exception {
        try (JiraRestClient connection = null;){
            System.out.println("Verifing Jira Ticketer Plugin...");
            this.validateConfiguration();
            connection = this.verifyConnection();
            VerifyCommand.validateProjectKey(connection, this.config.getProjectKey());
            this.validateIssueType(connection);
            this.verifyCustomFields(connection);
            Object var2_2 = null;
            return var2_2;
        }
    }

    @Deprecated
    protected final Object doExecute() throws Exception {
        return this.execute();
    }

    private void verifyCustomFields(JiraRestClient client) {
        System.out.println();
        System.out.println("Verifiing custom fields...");
        if (this.field == null || this.field.length == 0) {
            System.out.println("No custom fields configured");
            System.out.println("OK");
            return;
        }
        Set customFieldsSet = Arrays.stream(this.field).collect(Collectors.toSet());
        try {
            List<CimProject> cimProjects = JiraClientUtils.getIssueMetaData(client, "projects.issuetypes.fields", this.config.getIssueTypeId(), this.config.getProjectKey());
            if (!(cimProjects.iterator().hasNext() || cimProjects.iterator().next().getIssueTypes().iterator().hasNext() || ((CimIssueType)cimProjects.iterator().next().getIssueTypes().iterator().next()).getFields().isEmpty())) {
                throw new RuntimeException("There are custom fields defined, but none where found in jira");
            }
            Map fieldInfoMap = ((CimIssueType)cimProjects.iterator().next().getIssueTypes().iterator().next()).getFields();
            boolean overall = true;
            for (String customField : customFieldsSet) {
                boolean found = false;
                for (Map.Entry entry : fieldInfoMap.entrySet()) {
                    if (!customField.equals(((CimFieldInfo)entry.getValue()).getId())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    System.out.println("Custom field '" + customField + "' expected but not found in jira");
                }
                overall &= found;
            }
            if (!overall) {
                System.out.println("The jira integration will work, but not all custom fields will be mapped");
            } else {
                System.out.println("OK");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Could not read data from jira", e);
        }
    }

    private void validateConfiguration() {
        System.out.println();
        System.out.println("Validating configuration...");
        this.config.validateRequiredProperties();
        try {
            long issueTypeId = this.config.getIssueTypeId();
            if (issueTypeId < 0L) {
                throw new RuntimeException("The issue type id must be >= 0, but was " + issueTypeId);
            }
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException(nfe);
        }
        System.out.println("OK");
    }

    private void validateIssueType(JiraRestClient client) {
        System.out.println();
        System.out.println("Validating issue type with name '" + this.config.getIssueTypeId() + "' for project with key '" + this.config.getProjectKey() + "'...");
        try {
            List<CimProject> cimProjects = JiraClientUtils.getIssueMetaData(client, null, this.config.getIssueTypeId(), this.config.getProjectKey());
            if (!cimProjects.iterator().hasNext() || !cimProjects.iterator().next().getIssueTypes().iterator().hasNext()) {
                throw new RuntimeException("No issue type with id '" + this.config.getIssueTypeId() + "' found for project with key '" + this.config.getProjectKey() + "'");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Could not retrieve issue type with id '" + this.config.getIssueTypeId() + "' from with key = '" + this.config.getProjectKey() + "' from jira", e);
        }
        System.out.println("OK");
    }

    private JiraRestClient verifyConnection() {
        String host = this.config.getHost();
        String username = this.config.getUsername();
        String password = this.config.getPassword();
        try {
            System.out.println();
            System.out.println("Try connecting to jira server " + host + " with username: '" + username + "' and password: '" + password + "'...");
            JiraRestClient connection = JiraConnectionFactory.createConnection(host, username, password);
            ServerInfo serverInfo = (ServerInfo)connection.getMetadataClient().getServerInfo().get();
            System.out.println("Successfully connected to jira instance at " + host);
            System.out.println("Server Info:" + serverInfo.toString());
            System.out.println("OK");
            return connection;
        }
        catch (InterruptedException | ExecutionException | PluginException e) {
            throw new RuntimeException("Could not connect to jira server", e);
        }
    }

    private static void validateProjectKey(JiraRestClient client, String projectKey) {
        System.out.println("Validating project with key '" + projectKey + "'...");
        try {
            if (client.getProjectClient().getProject(projectKey).get() == null) {
                throw new RuntimeException("Project with key = '" + projectKey + "' does not exist");
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Could not retrieve project data for project with key '" + projectKey + "' from jira", e);
        }
        System.out.println("OK");
    }
}

