/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.builder;

import org.springframework.context.ApplicationContext;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.portlet.context.ConfigurablePortletApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MvcEnvironment {
    SERVLET,
    PORTLET;


    public static MvcEnvironment environmentFor(ApplicationContext applicationContext) {
        if (ClassUtils.isPresent("javax.portlet.PortletContext") && MvcEnvironment.isPortletApplicationContext(applicationContext)) {
            return PORTLET;
        }
        if (applicationContext instanceof WebApplicationContext) {
            return SERVLET;
        }
        return null;
    }

    private static boolean isPortletApplicationContext(ApplicationContext applicationContext) {
        return ClassUtils.isPresent("org.springframework.web.portlet.context.ConfigurablePortletApplicationContext") && applicationContext instanceof ConfigurablePortletApplicationContext;
    }
}

