/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.snapshot;

import java.io.Serializable;
import org.springframework.util.Assert;
import org.springframework.webflow.conversation.Conversation;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.CompositeFlowExecutionKey;

public abstract class AbstractSnapshottingFlowExecutionRepository
extends AbstractFlowExecutionRepository {
    private FlowExecutionSnapshotFactory snapshotFactory;

    public AbstractSnapshottingFlowExecutionRepository(ConversationManager conversationManager, FlowExecutionSnapshotFactory snapshotFactory) {
        super(conversationManager);
        Assert.notNull(snapshotFactory, "The flow execution snapshot factory is required");
        this.snapshotFactory = snapshotFactory;
    }

    public FlowExecutionSnapshotFactory getSnapshotFactory() {
        return this.snapshotFactory;
    }

    protected Serializable getSnapshotId(FlowExecutionKey key) {
        return ((CompositeFlowExecutionKey)key).getSnapshotId();
    }

    protected FlowExecutionSnapshot snapshot(FlowExecution flowExecution) {
        return this.snapshotFactory.createSnapshot(flowExecution);
    }

    protected FlowExecution restoreFlowExecution(FlowExecutionSnapshot snapshot, FlowExecutionKey key, Conversation conversation) {
        MutableAttributeMap conversationScope = (MutableAttributeMap)conversation.getAttribute("scope");
        String flowId = (String)conversation.getAttribute("name");
        return this.snapshotFactory.restoreExecution(snapshot, flowId, key, conversationScope, this);
    }

    protected void putConversationScope(FlowExecution flowExecution, Conversation conversation) {
        conversation.putAttribute("scope", flowExecution.getConversationScope());
    }
}

