/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.tags.form;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.AbstractHtmlElementTag;
import org.springframework.web.servlet.tags.form.OptionWriter;
import org.springframework.web.servlet.tags.form.SelectTag;
import org.springframework.web.servlet.tags.form.TagIdGenerator;
import org.springframework.web.servlet.tags.form.TagWriter;
import org.springframework.web.util.TagUtils;

public class OptionsTag
extends AbstractHtmlElementTag {
    private Object items;
    private String itemValue;
    private String itemLabel;
    private String disabled;

    public void setItems(Object items) {
        this.items = items;
    }

    protected Object getItems() {
        return this.items;
    }

    public void setItemValue(String itemValue) {
        Assert.hasText(itemValue, "'itemValue' must not be empty");
        this.itemValue = itemValue;
    }

    protected String getItemValue() {
        return this.itemValue;
    }

    public void setItemLabel(String itemLabel) {
        Assert.hasText(itemLabel, "'itemLabel' must not be empty");
        this.itemLabel = itemLabel;
    }

    protected String getItemLabel() {
        return this.itemLabel;
    }

    public void setDisabled(String disabled) {
        this.disabled = disabled;
    }

    protected String getDisabled() {
        return this.disabled;
    }

    protected boolean isDisabled() throws JspException {
        return this.evaluateBoolean("disabled", this.getDisabled());
    }

    protected int writeTagContent(TagWriter tagWriter) throws JspException {
        SelectTag selectTag = this.getSelectTag();
        ?[] items = this.getItems();
        ?[] itemsObject = null;
        if (items != null) {
            itemsObject = items instanceof String ? this.evaluate("items", items) : items;
        } else {
            Class<?> selectTagBoundType = selectTag.getBindStatus().getValueType();
            if (selectTagBoundType != null && selectTagBoundType.isEnum()) {
                itemsObject = selectTagBoundType.getEnumConstants();
            }
        }
        if (itemsObject != null) {
            String selectName = selectTag.getName();
            String itemValue = this.getItemValue();
            String itemLabel = this.getItemLabel();
            String valueProperty = itemValue != null ? ObjectUtils.getDisplayString(this.evaluate("itemValue", itemValue)) : null;
            String labelProperty = itemLabel != null ? ObjectUtils.getDisplayString(this.evaluate("itemLabel", itemLabel)) : null;
            OptionsWriter optionWriter = new OptionsWriter(selectName, itemsObject, valueProperty, labelProperty);
            optionWriter.writeOptions(tagWriter);
        }
        return 0;
    }

    protected String resolveId() throws JspException {
        Object id = this.evaluate("id", this.getId());
        if (id != null) {
            String idString = id.toString();
            return StringUtils.hasText(idString) ? TagIdGenerator.nextId(idString, this.pageContext) : null;
        }
        return null;
    }

    private SelectTag getSelectTag() {
        TagUtils.assertHasAncestorOfType((Tag)this, SelectTag.class, "options", "select");
        return (SelectTag)OptionsTag.findAncestorWithClass((Tag)this, SelectTag.class);
    }

    protected BindStatus getBindStatus() {
        return (BindStatus)this.pageContext.getAttribute("org.springframework.web.servlet.tags.form.SelectTag.listValue");
    }

    private class OptionsWriter
    extends OptionWriter {
        private final String selectName;

        public OptionsWriter(String selectName, Object optionSource, String valueProperty, String labelProperty) {
            super(optionSource, OptionsTag.this.getBindStatus(), valueProperty, labelProperty, OptionsTag.this.isHtmlEscape());
            this.selectName = selectName;
        }

        protected boolean isOptionDisabled() throws JspException {
            return OptionsTag.this.isDisabled();
        }

        protected void writeCommonAttributes(TagWriter tagWriter) throws JspException {
            OptionsTag.this.writeOptionalAttribute(tagWriter, "id", OptionsTag.this.resolveId());
            OptionsTag.this.writeOptionalAttributes(tagWriter);
        }

        protected String processOptionValue(String value) {
            return OptionsTag.this.processFieldValue(this.selectName, value, "option");
        }
    }
}

