/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.support;

import javax.servlet.http.HttpServletRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UrlPathHelper;

public class ServletUriComponentsBuilder
extends UriComponentsBuilder {
    protected ServletUriComponentsBuilder() {
    }

    public static ServletUriComponentsBuilder fromContextPath(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest(request);
        builder.replacePath(request.getContextPath());
        builder.replaceQuery(null);
        return builder;
    }

    public static ServletUriComponentsBuilder fromServletMapping(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromContextPath(request);
        if (StringUtils.hasText(new UrlPathHelper().getPathWithinServletMapping(request))) {
            builder.path(request.getServletPath());
        }
        return builder;
    }

    public static ServletUriComponentsBuilder fromRequestUri(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest(request);
        builder.replacePath(request.getRequestURI());
        builder.replaceQuery(null);
        return builder;
    }

    public static ServletUriComponentsBuilder fromRequest(HttpServletRequest request) {
        String scheme = request.getScheme();
        int port = request.getServerPort();
        String host = request.getServerName();
        String header = request.getHeader("X-Forwarded-Host");
        if (StringUtils.hasText(header)) {
            String[] hosts = StringUtils.commaDelimitedListToStringArray(header);
            String hostToUse = hosts[0];
            if (hostToUse.contains(":")) {
                String[] hostAndPort = StringUtils.split(hostToUse, ":");
                host = hostAndPort[0];
                port = Integer.parseInt(hostAndPort[1]);
            } else {
                host = hostToUse;
            }
        }
        ServletUriComponentsBuilder builder = new ServletUriComponentsBuilder();
        builder.scheme(scheme);
        builder.host(host);
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            builder.port(port);
        }
        builder.path(request.getRequestURI());
        builder.query(request.getQueryString());
        return builder;
    }

    public static ServletUriComponentsBuilder fromCurrentContextPath() {
        return ServletUriComponentsBuilder.fromContextPath(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentServletMapping() {
        return ServletUriComponentsBuilder.fromServletMapping(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentRequestUri() {
        return ServletUriComponentsBuilder.fromRequestUri(ServletUriComponentsBuilder.getCurrentRequest());
    }

    public static ServletUriComponentsBuilder fromCurrentRequest() {
        return ServletUriComponentsBuilder.fromRequest(ServletUriComponentsBuilder.getCurrentRequest());
    }

    protected static HttpServletRequest getCurrentRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        Assert.state(requestAttributes != null, "Could not find current request via RequestContextHolder");
        Assert.isInstanceOf(ServletRequestAttributes.class, requestAttributes);
        HttpServletRequest servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
        Assert.state(servletRequest != null, "Could not find current HttpServletRequest");
        return servletRequest;
    }
}

