/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.scheduling.quartz.JobDetailAwareTrigger;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronTriggerBean
extends CronTrigger
implements JobDetailAwareTrigger,
BeanNameAware,
InitializingBean {
    private static final Constants constants = new Constants(CronTrigger.class);
    private JobDetail jobDetail;
    private String beanName;
    private long startDelay = 0L;

    public void setJobDataAsMap(Map<String, ?> jobDataAsMap) {
        this.getJobDataMap().putAll(jobDataAsMap);
    }

    public void setMisfireInstructionName(String constantName) {
        this.setMisfireInstruction(constants.asNumber(constantName).intValue());
    }

    public void setTriggerListenerNames(String ... names) {
        for (String name : names) {
            this.addTriggerListener(name);
        }
    }

    public void setStartDelay(long startDelay) {
        Assert.state(startDelay >= 0L, "Start delay cannot be negative.");
        this.startDelay = startDelay;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    @Override
    public JobDetail getJobDetail() {
        return this.jobDetail;
    }

    @Override
    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.getName() == null) {
            this.setName(this.beanName);
        }
        if (this.getGroup() == null) {
            this.setGroup("DEFAULT");
        }
        if (this.startDelay > 0L || this.getStartTime() == null) {
            this.setStartTime(new Date(System.currentTimeMillis() + this.startDelay));
        }
        if (this.getTimeZone() == null) {
            this.setTimeZone(TimeZone.getDefault());
        }
        if (this.jobDetail != null) {
            this.setJobName(this.jobDetail.getName());
            this.setJobGroup(this.jobDetail.getGroup());
        }
    }
}

