/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jdo;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import javax.jdo.JDOException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.orm.jdo.JdoAccessor;
import org.springframework.orm.jdo.JdoCallback;
import org.springframework.orm.jdo.JdoOperations;
import org.springframework.orm.jdo.PersistenceManagerFactoryUtils;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class JdoTemplate
extends JdoAccessor
implements JdoOperations {
    private boolean allowCreate = true;
    private boolean exposeNativePersistenceManager = false;

    public JdoTemplate() {
    }

    public JdoTemplate(PersistenceManagerFactory pmf) {
        this.setPersistenceManagerFactory(pmf);
        this.afterPropertiesSet();
    }

    public JdoTemplate(PersistenceManagerFactory pmf, boolean allowCreate) {
        this.setPersistenceManagerFactory(pmf);
        this.setAllowCreate(allowCreate);
        this.afterPropertiesSet();
    }

    public void setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
    }

    public boolean isAllowCreate() {
        return this.allowCreate;
    }

    public void setExposeNativePersistenceManager(boolean exposeNativePersistenceManager) {
        this.exposeNativePersistenceManager = exposeNativePersistenceManager;
    }

    public boolean isExposeNativePersistenceManager() {
        return this.exposeNativePersistenceManager;
    }

    @Override
    public <T> T execute(JdoCallback<T> action) throws DataAccessException {
        return this.execute(action, this.isExposeNativePersistenceManager());
    }

    @Override
    public Collection executeFind(JdoCallback<?> action) throws DataAccessException {
        Object result = this.execute(action, this.isExposeNativePersistenceManager());
        if (result != null && !(result instanceof Collection)) {
            throw new InvalidDataAccessApiUsageException("Result object returned from JdoCallback isn't a Collection: [" + result + "]");
        }
        return (Collection)result;
    }

    public <T> T execute(JdoCallback<T> action, boolean exposeNativePersistenceManager) throws DataAccessException {
        Assert.notNull(action, "Callback object must not be null");
        PersistenceManager pm = PersistenceManagerFactoryUtils.getPersistenceManager(this.getPersistenceManagerFactory(), this.isAllowCreate());
        boolean existingTransaction = TransactionSynchronizationManager.hasResource(this.getPersistenceManagerFactory());
        try {
            PersistenceManager pmToExpose = exposeNativePersistenceManager ? pm : this.createPersistenceManagerProxy(pm);
            T result = action.doInJdo(pmToExpose);
            this.flushIfNecessary(pm, existingTransaction);
            T t = this.postProcessResult(result, pm, existingTransaction);
            return t;
        }
        catch (JDOException ex) {
            throw this.convertJdoAccessException(ex);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            PersistenceManagerFactoryUtils.releasePersistenceManager(pm, this.getPersistenceManagerFactory());
        }
    }

    protected PersistenceManager createPersistenceManagerProxy(PersistenceManager pm) {
        Class<?>[] ifcs = ClassUtils.getAllInterfacesForClass(pm.getClass(), this.getClass().getClassLoader());
        return (PersistenceManager)Proxy.newProxyInstance(pm.getClass().getClassLoader(), ifcs, (InvocationHandler)new CloseSuppressingInvocationHandler(pm));
    }

    protected <T> T postProcessResult(T result, PersistenceManager pm, boolean existingTransaction) {
        return result;
    }

    @Override
    public Object getObjectById(final Object objectId) throws DataAccessException {
        return this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                return pm.getObjectById(objectId, true);
            }
        }, true);
    }

    @Override
    public <T> T getObjectById(final Class<T> entityClass, final Object idValue) throws DataAccessException {
        return this.execute(new JdoCallback<T>(){

            @Override
            public T doInJdo(PersistenceManager pm) throws JDOException {
                return pm.getObjectById(entityClass, idValue);
            }
        }, true);
    }

    @Override
    public void evict(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evict(entity);
                return null;
            }
        }, true);
    }

    @Override
    public void evictAll(final Collection entities) throws DataAccessException {
        this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evictAll(entities);
                return null;
            }
        }, true);
    }

    @Override
    public void evictAll() throws DataAccessException {
        this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.evictAll();
                return null;
            }
        }, true);
    }

    @Override
    public void refresh(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refresh(entity);
                return null;
            }
        }, true);
    }

    @Override
    public void refreshAll(final Collection entities) throws DataAccessException {
        this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refreshAll(entities);
                return null;
            }
        }, true);
    }

    @Override
    public void refreshAll() throws DataAccessException {
        this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.refreshAll();
                return null;
            }
        }, true);
    }

    @Override
    public <T> T makePersistent(final T entity) throws DataAccessException {
        return this.execute(new JdoCallback<T>(){

            @Override
            public T doInJdo(PersistenceManager pm) throws JDOException {
                return pm.makePersistent(entity);
            }
        }, true);
    }

    @Override
    public <T> Collection<T> makePersistentAll(final Collection<T> entities) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback<Collection<T>>(){

            @Override
            public Collection<T> doInJdo(PersistenceManager pm) throws JDOException {
                return pm.makePersistentAll(entities);
            }
        }, true);
    }

    @Override
    public void deletePersistent(final Object entity) throws DataAccessException {
        this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.deletePersistent(entity);
                return null;
            }
        }, true);
    }

    @Override
    public void deletePersistentAll(final Collection entities) throws DataAccessException {
        this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.deletePersistentAll(entities);
                return null;
            }
        }, true);
    }

    @Override
    public <T> T detachCopy(final T entity) {
        return this.execute(new JdoCallback<T>(){

            @Override
            public T doInJdo(PersistenceManager pm) throws JDOException {
                return pm.detachCopy(entity);
            }
        }, true);
    }

    @Override
    public <T> Collection<T> detachCopyAll(final Collection<T> entities) {
        return (Collection)this.execute(new JdoCallback<Collection<T>>(){

            @Override
            public Collection<T> doInJdo(PersistenceManager pm) throws JDOException {
                return pm.detachCopyAll(entities);
            }
        }, true);
    }

    @Override
    public void flush() throws DataAccessException {
        this.execute(new JdoCallback<Object>(){

            @Override
            public Object doInJdo(PersistenceManager pm) throws JDOException {
                pm.flush();
                return null;
            }
        }, true);
    }

    @Override
    public <T> Collection<T> find(Class<T> entityClass) throws DataAccessException {
        return this.find(entityClass, null, null);
    }

    @Override
    public <T> Collection<T> find(Class<T> entityClass, String filter) throws DataAccessException {
        return this.find(entityClass, filter, null);
    }

    @Override
    public <T> Collection<T> find(final Class<T> entityClass, final String filter, final String ordering) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback<Collection<T>>(){

            @Override
            public Collection<T> doInJdo(PersistenceManager pm) throws JDOException {
                Query query = filter != null ? pm.newQuery(entityClass, filter) : pm.newQuery(entityClass);
                JdoTemplate.this.prepareQuery(query);
                if (ordering != null) {
                    query.setOrdering(ordering);
                }
                return (Collection)query.execute();
            }
        }, true);
    }

    @Override
    public <T> Collection<T> find(Class<T> entityClass, String filter, String parameters, Object ... values) throws DataAccessException {
        return this.find(entityClass, filter, parameters, values, null);
    }

    @Override
    public <T> Collection<T> find(final Class<T> entityClass, final String filter, final String parameters, final Object[] values, final String ordering) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback<Collection<T>>(){

            @Override
            public Collection<T> doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                JdoTemplate.this.prepareQuery(query);
                query.declareParameters(parameters);
                if (ordering != null) {
                    query.setOrdering(ordering);
                }
                return (Collection)query.executeWithArray(values);
            }
        }, true);
    }

    @Override
    public <T> Collection<T> find(Class<T> entityClass, String filter, String parameters, Map<String, ?> values) throws DataAccessException {
        return this.find(entityClass, filter, parameters, values, null);
    }

    @Override
    public <T> Collection<T> find(final Class<T> entityClass, final String filter, final String parameters, final Map<String, ?> values, final String ordering) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback<Collection<T>>(){

            @Override
            public Collection<T> doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(entityClass, filter);
                JdoTemplate.this.prepareQuery(query);
                query.declareParameters(parameters);
                if (ordering != null) {
                    query.setOrdering(ordering);
                }
                return (Collection)query.executeWithMap(values);
            }
        }, true);
    }

    @Override
    public Collection find(final String language, final Object queryObject) throws DataAccessException {
        return this.execute(new JdoCallback<Collection>(){

            @Override
            public Collection doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(language, queryObject);
                JdoTemplate.this.prepareQuery(query);
                return (Collection)query.execute();
            }
        }, true);
    }

    @Override
    public Collection find(final String queryString) throws DataAccessException {
        return this.execute(new JdoCallback<Collection>(){

            @Override
            public Collection doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(queryString);
                JdoTemplate.this.prepareQuery(query);
                return (Collection)query.execute();
            }
        }, true);
    }

    @Override
    public Collection find(final String queryString, final Object ... values) throws DataAccessException {
        return this.execute(new JdoCallback<Collection>(){

            @Override
            public Collection doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(queryString);
                JdoTemplate.this.prepareQuery(query);
                return (Collection)query.executeWithArray(values);
            }
        }, true);
    }

    @Override
    public Collection find(final String queryString, final Map<String, ?> values) throws DataAccessException {
        return this.execute(new JdoCallback<Collection>(){

            @Override
            public Collection doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newQuery(queryString);
                JdoTemplate.this.prepareQuery(query);
                return (Collection)query.executeWithMap(values);
            }
        }, true);
    }

    @Override
    public <T> Collection<T> findByNamedQuery(final Class<T> entityClass, final String queryName) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback<Collection<T>>(){

            @Override
            public Collection<T> doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newNamedQuery(entityClass, queryName);
                JdoTemplate.this.prepareQuery(query);
                return (Collection)query.execute();
            }
        }, true);
    }

    @Override
    public <T> Collection<T> findByNamedQuery(final Class<T> entityClass, final String queryName, final Object ... values) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback<Collection<T>>(){

            @Override
            public Collection<T> doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newNamedQuery(entityClass, queryName);
                JdoTemplate.this.prepareQuery(query);
                return (Collection)query.executeWithArray(values);
            }
        }, true);
    }

    @Override
    public <T> Collection<T> findByNamedQuery(final Class<T> entityClass, final String queryName, final Map<String, ?> values) throws DataAccessException {
        return (Collection)this.execute(new JdoCallback<Collection<T>>(){

            @Override
            public Collection<T> doInJdo(PersistenceManager pm) throws JDOException {
                Query query = pm.newNamedQuery(entityClass, queryName);
                JdoTemplate.this.prepareQuery(query);
                return (Collection)query.executeWithMap(values);
            }
        }, true);
    }

    public void prepareQuery(Query query) throws JDOException {
        PersistenceManagerFactoryUtils.applyTransactionTimeout(query, this.getPersistenceManagerFactory(), this.getJdoDialect());
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final PersistenceManager target;

        public CloseSuppressingInvocationHandler(PersistenceManager target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Query) {
                    JdoTemplate.this.prepareQuery((Query)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

