/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.ibatis;

import com.ibatis.sqlmap.client.SqlMapClient;
import com.ibatis.sqlmap.client.SqlMapExecutor;
import com.ibatis.sqlmap.client.SqlMapSession;
import com.ibatis.sqlmap.client.event.RowHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.CannotGetJdbcConnectionException;
import org.springframework.jdbc.JdbcUpdateAffectedIncorrectNumberOfRowsException;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.jdbc.support.JdbcAccessor;
import org.springframework.orm.ibatis.SqlMapClientCallback;
import org.springframework.orm.ibatis.SqlMapClientOperations;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SqlMapClientTemplate
extends JdbcAccessor
implements SqlMapClientOperations {
    private SqlMapClient sqlMapClient;

    public SqlMapClientTemplate() {
    }

    public SqlMapClientTemplate(SqlMapClient sqlMapClient) {
        this.setSqlMapClient(sqlMapClient);
        this.afterPropertiesSet();
    }

    public SqlMapClientTemplate(DataSource dataSource, SqlMapClient sqlMapClient) {
        this.setDataSource(dataSource);
        this.setSqlMapClient(sqlMapClient);
        this.afterPropertiesSet();
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) {
        this.sqlMapClient = sqlMapClient;
    }

    public SqlMapClient getSqlMapClient() {
        return this.sqlMapClient;
    }

    @Override
    public DataSource getDataSource() {
        DataSource ds = super.getDataSource();
        return ds != null ? ds : this.sqlMapClient.getDataSource();
    }

    @Override
    public void afterPropertiesSet() {
        if (this.sqlMapClient == null) {
            throw new IllegalArgumentException("Property 'sqlMapClient' is required");
        }
        super.afterPropertiesSet();
    }

    /*
     * Loose catch block
     */
    public <T> T execute(SqlMapClientCallback<T> action) throws DataAccessException {
        Assert.notNull(action, "Callback object must not be null");
        Assert.notNull(this.sqlMapClient, "No SqlMapClient specified");
        SqlMapSession session = this.sqlMapClient.openSession();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Opened SqlMapSession [" + session + "] for iBATIS operation");
        }
        Connection ibatisCon = null;
        try {
            Connection springCon = null;
            DataSource dataSource = this.getDataSource();
            boolean transactionAware = dataSource instanceof TransactionAwareDataSourceProxy;
            try {
                ibatisCon = session.getCurrentConnection();
                if (ibatisCon == null) {
                    springCon = transactionAware ? dataSource.getConnection() : DataSourceUtils.doGetConnection(dataSource);
                    session.setUserConnection(springCon);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Obtained JDBC Connection [" + springCon + "] for iBATIS operation");
                    }
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Reusing JDBC Connection [" + ibatisCon + "] for iBATIS operation");
                }
            }
            catch (SQLException ex) {
                throw new CannotGetJdbcConnectionException("Could not get JDBC Connection", ex);
            }
            try {
                T ex = action.doInSqlMapClient((SqlMapExecutor)session);
            }
            catch (SQLException ex) {
                throw this.getExceptionTranslator().translate("SqlMapClient operation", null, ex);
            }
            finally {
                try {
                    if (springCon != null) {
                        if (transactionAware) {
                            springCon.close();
                        } else {
                            DataSourceUtils.doReleaseConnection(springCon, dataSource);
                        }
                    }
                }
                catch (Throwable ex) {
                    this.logger.debug("Could not close JDBC Connection", ex);
                }
            }
            return ex;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (ibatisCon == null) {
                session.close();
            }
        }
    }

    @Deprecated
    public List executeWithListResult(SqlMapClientCallback<List> action) throws DataAccessException {
        return this.execute(action);
    }

    @Deprecated
    public Map executeWithMapResult(SqlMapClientCallback<Map> action) throws DataAccessException {
        return this.execute(action);
    }

    @Override
    public Object queryForObject(String statementName) throws DataAccessException {
        return this.queryForObject(statementName, null);
    }

    @Override
    public Object queryForObject(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Object>(){

            @Override
            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(statementName, parameterObject);
            }
        });
    }

    @Override
    public Object queryForObject(final String statementName, final Object parameterObject, final Object resultObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Object>(){

            @Override
            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForObject(statementName, parameterObject, resultObject);
            }
        });
    }

    @Override
    public List queryForList(String statementName) throws DataAccessException {
        return this.queryForList(statementName, null);
    }

    @Override
    public List queryForList(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<List>(){

            @Override
            public List doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(statementName, parameterObject);
            }
        });
    }

    @Override
    public List queryForList(String statementName, int skipResults, int maxResults) throws DataAccessException {
        return this.queryForList(statementName, null, skipResults, maxResults);
    }

    @Override
    public List queryForList(final String statementName, final Object parameterObject, final int skipResults, final int maxResults) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<List>(){

            @Override
            public List doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForList(statementName, parameterObject, skipResults, maxResults);
            }
        });
    }

    @Override
    public void queryWithRowHandler(String statementName, RowHandler rowHandler) throws DataAccessException {
        this.queryWithRowHandler(statementName, null, rowHandler);
    }

    @Override
    public void queryWithRowHandler(final String statementName, final Object parameterObject, final RowHandler rowHandler) throws DataAccessException {
        this.execute(new SqlMapClientCallback<Object>(){

            @Override
            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                executor.queryWithRowHandler(statementName, parameterObject, rowHandler);
                return null;
            }
        });
    }

    @Override
    public Map queryForMap(final String statementName, final Object parameterObject, final String keyProperty) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Map>(){

            @Override
            public Map doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(statementName, parameterObject, keyProperty);
            }
        });
    }

    @Override
    public Map queryForMap(final String statementName, final Object parameterObject, final String keyProperty, final String valueProperty) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Map>(){

            @Override
            public Map doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.queryForMap(statementName, parameterObject, keyProperty, valueProperty);
            }
        });
    }

    @Override
    public Object insert(String statementName) throws DataAccessException {
        return this.insert(statementName, null);
    }

    @Override
    public Object insert(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Object>(){

            @Override
            public Object doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.insert(statementName, parameterObject);
            }
        });
    }

    @Override
    public int update(String statementName) throws DataAccessException {
        return this.update(statementName, null);
    }

    @Override
    public int update(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.update(statementName, parameterObject);
            }
        });
    }

    @Override
    public void update(String statementName, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        int actualRowsAffected = this.update(statementName, parameterObject);
        if (actualRowsAffected != requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(statementName, requiredRowsAffected, actualRowsAffected);
        }
    }

    @Override
    public int delete(String statementName) throws DataAccessException {
        return this.delete(statementName, null);
    }

    @Override
    public int delete(final String statementName, final Object parameterObject) throws DataAccessException {
        return this.execute(new SqlMapClientCallback<Integer>(){

            @Override
            public Integer doInSqlMapClient(SqlMapExecutor executor) throws SQLException {
                return executor.delete(statementName, parameterObject);
            }
        });
    }

    @Override
    public void delete(String statementName, Object parameterObject, int requiredRowsAffected) throws DataAccessException {
        int actualRowsAffected = this.delete(statementName, parameterObject);
        if (actualRowsAffected != requiredRowsAffected) {
            throw new JdbcUpdateAffectedIncorrectNumberOfRowsException(statementName, requiredRowsAffected, actualRowsAffected);
        }
    }
}

