/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.support.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.jms.support.converter.MessageConversionException;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.converter.MessageType;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingJacksonMessageConverter
implements MessageConverter,
BeanClassLoaderAware {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private ObjectMapper objectMapper = new ObjectMapper();
    private MessageType targetType = MessageType.BYTES;
    private String encoding = "UTF-8";
    private String encodingPropertyName;
    private String typeIdPropertyName;
    private Map<String, Class<?>> idClassMappings = new HashMap();
    private Map<Class<?>, String> classIdMappings = new HashMap();
    private ClassLoader beanClassLoader;

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull(objectMapper, "ObjectMapper must not be null");
        this.objectMapper = objectMapper;
    }

    public void setTargetType(MessageType targetType) {
        Assert.notNull((Object)targetType, "MessageType must not be null");
        this.targetType = targetType;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setEncodingPropertyName(String encodingPropertyName) {
        this.encodingPropertyName = encodingPropertyName;
    }

    public void setTypeIdPropertyName(String typeIdPropertyName) {
        this.typeIdPropertyName = typeIdPropertyName;
    }

    public void setTypeIdMappings(Map<String, Class<?>> typeIdMappings) {
        this.idClassMappings = new HashMap();
        for (Map.Entry<String, Class<?>> entry : typeIdMappings.entrySet()) {
            String id = entry.getKey();
            Class<?> clazz = entry.getValue();
            this.idClassMappings.put(id, clazz);
            this.classIdMappings.put(clazz, id);
        }
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public Message toMessage(Object object, Session session) throws JMSException, MessageConversionException {
        Message message;
        try {
            switch (this.targetType) {
                case TEXT: {
                    message = this.mapToTextMessage(object, session, this.objectMapper);
                    break;
                }
                case BYTES: {
                    message = this.mapToBytesMessage(object, session, this.objectMapper);
                    break;
                }
                default: {
                    message = this.mapToMessage(object, session, this.objectMapper, this.targetType);
                    break;
                }
            }
        }
        catch (IOException ex) {
            throw new MessageConversionException("Could not map JSON object [" + object + "]", ex);
        }
        this.setTypeIdOnMessage(object, message);
        return message;
    }

    @Override
    public Object fromMessage(Message message) throws JMSException, MessageConversionException {
        try {
            JavaType targetJavaType = this.getJavaTypeForMessage(message);
            return this.convertToObject(message, targetJavaType);
        }
        catch (IOException ex) {
            throw new MessageConversionException("Failed to convert JSON message content", ex);
        }
    }

    protected TextMessage mapToTextMessage(Object object, Session session, ObjectMapper objectMapper) throws JMSException, IOException {
        StringWriter writer = new StringWriter();
        objectMapper.writeValue(writer, object);
        return session.createTextMessage(writer.toString());
    }

    protected BytesMessage mapToBytesMessage(Object object, Session session, ObjectMapper objectMapper) throws JMSException, IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, this.encoding);
        objectMapper.writeValue(writer, object);
        BytesMessage message = session.createBytesMessage();
        message.writeBytes(bos.toByteArray());
        if (this.encodingPropertyName != null) {
            message.setStringProperty(this.encodingPropertyName, this.encoding);
        }
        return message;
    }

    protected Message mapToMessage(Object object, Session session, ObjectMapper objectMapper, MessageType targetType) throws JMSException, IOException {
        throw new IllegalArgumentException("Unsupported message type [" + (Object)((Object)targetType) + "]. MappingJacksonMessageConverter by default only supports TextMessages and BytesMessages.");
    }

    protected void setTypeIdOnMessage(Object object, Message message) throws JMSException {
        if (this.typeIdPropertyName != null) {
            String typeId = this.classIdMappings.get(object.getClass());
            if (typeId == null) {
                typeId = object.getClass().getName();
            }
            message.setStringProperty(this.typeIdPropertyName, typeId);
        }
    }

    private Object convertToObject(Message message, JavaType targetJavaType) throws JMSException, IOException {
        if (message instanceof TextMessage) {
            return this.convertFromTextMessage((TextMessage)message, targetJavaType);
        }
        if (message instanceof BytesMessage) {
            return this.convertFromBytesMessage((BytesMessage)message, targetJavaType);
        }
        return this.convertFromMessage(message, targetJavaType);
    }

    protected Object convertFromTextMessage(TextMessage message, JavaType targetJavaType) throws JMSException, IOException {
        String body = message.getText();
        return this.objectMapper.readValue(body, targetJavaType);
    }

    protected Object convertFromBytesMessage(BytesMessage message, JavaType targetJavaType) throws JMSException, IOException {
        String encoding = this.encoding;
        if (this.encodingPropertyName != null && message.propertyExists(this.encodingPropertyName)) {
            encoding = message.getStringProperty(this.encodingPropertyName);
        }
        byte[] bytes = new byte[(int)message.getBodyLength()];
        message.readBytes(bytes);
        try {
            String body = new String(bytes, encoding);
            return this.objectMapper.readValue(body, targetJavaType);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MessageConversionException("Cannot convert bytes to String", ex);
        }
    }

    protected Object convertFromMessage(Message message, JavaType targetJavaType) throws JMSException, IOException {
        throw new IllegalArgumentException("Unsupported message type [" + message.getClass() + "]. MappingJacksonMessageConverter by default only supports TextMessages and BytesMessages.");
    }

    protected JavaType getJavaTypeForMessage(Message message) throws JMSException {
        String typeId = message.getStringProperty(this.typeIdPropertyName);
        if (typeId == null) {
            throw new MessageConversionException("Could not find type id property [" + this.typeIdPropertyName + "]");
        }
        Class<?> mappedClass = this.idClassMappings.get(typeId);
        if (mappedClass != null) {
            return TypeFactory.type(mappedClass);
        }
        try {
            Class<?> typeClass = ClassUtils.forName(typeId, this.beanClassLoader);
            return TypeFactory.type(typeClass);
        }
        catch (Throwable ex) {
            throw new MessageConversionException("Failed to resolve type id [" + typeId + "]", ex);
        }
    }
}

