/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.expression.el;

import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ValueExpression;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.PropertyNotFoundException;
import org.springframework.binding.expression.el.ELContextFactory;
import org.springframework.util.Assert;

public class ELExpression
implements Expression {
    private ELContextFactory elContextFactory;
    private ValueExpression valueExpression;

    public ELExpression(ELContextFactory factory, ValueExpression valueExpression) {
        Assert.notNull(factory, "The ELContextFactory is required to evaluate EL expressions");
        Assert.notNull(valueExpression, "The EL ValueExpression is required for evaluation");
        this.elContextFactory = factory;
        this.valueExpression = valueExpression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue(Object context) throws EvaluationException {
        block4: {
            ELContext ctx = this.elContextFactory.getELContext(context);
            Object result = this.valueExpression.getValue(ctx);
            if (result != null || ctx.isPropertyResolved()) return result;
            if (!this.getExpressionString().equals("null")) break block4;
            return null;
        }
        try {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "The expression '" + this.getExpressionString() + "' did not resolve... is the base variable '" + this.getBaseVariable() + "' spelled correctly?");
        }
        catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(context.getClass(), this.getExpressionString(), e);
        }
        catch (ELException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An ELException occurred getting the value for expression '" + this.getExpressionString() + "' on context [" + context.getClass() + "]", e);
        }
    }

    public void setValue(Object context, Object value) throws EvaluationException {
        ELContext ctx = this.elContextFactory.getELContext(context);
        try {
            this.valueExpression.setValue(ctx, value);
            if (!ctx.isPropertyResolved()) {
                throw new EvaluationException(context.getClass(), this.getExpressionString(), "The expression '" + this.getExpressionString() + "' did not resolve... is the base variable ''" + this.getBaseVariable() + "' spelled correctly?");
            }
        }
        catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(context.getClass(), this.getExpressionString(), e);
        }
        catch (ELException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An ELException occurred setting the value of expression '" + this.getExpressionString() + "' on context [" + context.getClass() + "] to [" + value + "]", e);
        }
    }

    public Class getValueType(Object context) {
        ELContext ctx = this.elContextFactory.getELContext(context);
        try {
            return this.valueExpression.getType(ctx);
        }
        catch (javax.el.PropertyNotFoundException e) {
            throw new PropertyNotFoundException(context.getClass(), this.getExpressionString(), e);
        }
        catch (ELException e) {
            throw new EvaluationException(context.getClass(), this.getExpressionString(), "An ELException occurred getting the value type for expression '" + this.getExpressionString() + "' on context [" + context.getClass() + "]", e);
        }
    }

    public String getExpressionString() {
        return this.valueExpression.getExpressionString();
    }

    private String getBaseVariable() {
        String expressionString = this.getExpressionString();
        int firstDot = expressionString.indexOf(46);
        if (firstDot == -1) {
            return expressionString;
        }
        return expressionString.substring(0, firstDot);
    }

    public int hashCode() {
        return this.valueExpression.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ELExpression)) {
            return false;
        }
        ELExpression other = (ELExpression)o;
        return this.valueExpression.equals((Object)other.valueExpression);
    }

    public String toString() {
        return this.getExpressionString();
    }
}

