/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.convert.converters;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.converters.Converter;
import org.springframework.core.GenericCollectionTypeResolver;
import org.springframework.core.JdkVersion;

public class ObjectToCollection
implements Converter {
    private ConversionService conversionService;
    private ConversionExecutor elementConverter;

    public ObjectToCollection(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ObjectToCollection(ConversionExecutor elementConverter) {
        this.elementConverter = elementConverter;
    }

    public Class getSourceClass() {
        return Object.class;
    }

    public Class getTargetClass() {
        return Collection.class;
    }

    public Object convertSourceToTargetClass(Object source, Class targetClass) throws Exception {
        if (source == null) {
            return null;
        }
        Class collectionImplClass = this.getCollectionImplClass(targetClass);
        Constructor constructor = collectionImplClass.getConstructor(null);
        Collection collection = (Collection)constructor.newInstance(null);
        ConversionExecutor converter = this.getElementConverter(source, targetClass);
        Object value = converter != null ? converter.execute(source) : source;
        collection.add(value);
        return collection;
    }

    private Class getCollectionImplClass(Class targetClass) {
        if (targetClass.isInterface()) {
            if (List.class.equals((Object)targetClass)) {
                return ArrayList.class;
            }
            if (Set.class.equals((Object)targetClass)) {
                return LinkedHashSet.class;
            }
            if (SortedSet.class.equals((Object)targetClass)) {
                return TreeSet.class;
            }
            throw new IllegalArgumentException("Unsupported collection interface [" + targetClass.getName() + "]");
        }
        return targetClass;
    }

    private ConversionExecutor getElementConverter(Object source, Class targetClass) {
        Class<?> elementType;
        if (this.elementConverter != null) {
            return this.elementConverter;
        }
        if (JdkVersion.isAtLeastJava15() && (elementType = GenericCollectionTypeResolver.getCollectionType(targetClass)) != null) {
            Class<?> componentType = source.getClass().getComponentType();
            return this.conversionService.getConversionExecutor(componentType, elementType);
        }
        return null;
    }
}

