/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jdbc.util;

import org.hibernate.jdbc.util.FormatStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLStatementLogger {
    private static final Logger log = LoggerFactory.getLogger("org.hibernate.SQL");
    private boolean logToStdout;
    private boolean formatSql;

    public SQLStatementLogger() {
        this(false, false);
    }

    public SQLStatementLogger(boolean logToStdout, boolean formatSql) {
        this.logToStdout = logToStdout;
        this.formatSql = formatSql;
    }

    public boolean isLogToStdout() {
        return this.logToStdout;
    }

    public void setLogToStdout(boolean logToStdout) {
        this.logToStdout = logToStdout;
    }

    public boolean isFormatSql() {
        return this.formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public void logStatement(String statement, FormatStyle style) {
        if (log.isDebugEnabled() || this.logToStdout) {
            style = this.determineActualStyle(style);
            statement = style.getFormatter().format(statement);
        }
        log.debug(statement);
        if (this.logToStdout) {
            System.out.println("Hibernate: " + statement);
        }
    }

    private FormatStyle determineActualStyle(FormatStyle style) {
        return this.formatSql ? style : FormatStyle.NONE;
    }
}

