/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs.resources.common;

import java.util.List;
import javax.persistence.Query;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.jpa.rs.PersistenceContext;
import org.eclipse.persistence.jpa.rs.resources.common.AbstractResource;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.StreamingOutputMarshaller;
import org.eclipse.persistence.jpa.rs.util.list.MultiResultQueryList;
import org.eclipse.persistence.jpa.rs.util.list.MultiResultQueryListItem;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReportQuery;

public abstract class AbstractQueryResource
extends AbstractResource {
    protected Response namedQueryUpdateInternal(String version, String persistenceUnit, String name, HttpHeaders hh, UriInfo ui) {
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, ui.getBaseUri(), version, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        int result = app.queryExecuteUpdate(AbstractQueryResource.getMatrixParameters(ui, persistenceUnit), name, AbstractQueryResource.getMatrixParameters(ui, name), AbstractQueryResource.getQueryParameters(ui));
        JAXBElement<Integer> jaxbElement = new JAXBElement<Integer>(new QName("result"), new Integer(result).getClass(), result);
        return Response.ok(new StreamingOutputMarshaller(app, jaxbElement, hh.getAcceptableMediaTypes())).build();
    }

    protected Response namedQueryInternal(String version, String persistenceUnit, String name, HttpHeaders hh, UriInfo ui) {
        PersistenceContext app = this.getPersistenceContext(persistenceUnit, ui.getBaseUri(), version, null);
        if (app == null) {
            JPARSLogger.fine("jpars_could_not_find_persistence_context", new Object[]{persistenceUnit});
            return Response.status(Response.Status.NOT_FOUND).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
        }
        Query query = app.buildQuery(AbstractQueryResource.getMatrixParameters(ui, persistenceUnit), name, AbstractQueryResource.getMatrixParameters(ui, name), AbstractQueryResource.getQueryParameters(ui));
        DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
        if (dbQuery instanceof ReportQuery) {
            List<ReportItem> reportItems = ((ReportQuery)dbQuery).getItems();
            List queryResults = query.getResultList();
            if (queryResults != null && !queryResults.isEmpty()) {
                MultiResultQueryList list = this.populateReportQueryResponse(queryResults, reportItems);
                if (list != null) {
                    return Response.ok(new StreamingOutputMarshaller(app, (Object)list, hh.getAcceptableMediaTypes())).build();
                }
                return Response.status(Response.Status.INTERNAL_SERVER_ERROR).type(StreamingOutputMarshaller.getResponseMediaType(hh)).build();
            }
            return Response.ok(new StreamingOutputMarshaller(app, (Object)queryResults, hh.getAcceptableMediaTypes())).build();
        }
        List results = query.getResultList();
        return Response.ok(new StreamingOutputMarshaller(app, (Object)results, hh.getAcceptableMediaTypes())).build();
    }

    private MultiResultQueryList populateReportQueryResponse(List<Object[]> results, List<ReportItem> reportItems) {
        MultiResultQueryList response = new MultiResultQueryList();
        for (Object[] result : results) {
            MultiResultQueryListItem queryResultListItem = new MultiResultQueryListItem();
            List<JAXBElement> jaxbFields = this.createShellJAXBElementList(reportItems, result);
            if (jaxbFields == null) {
                return null;
            }
            queryResultListItem.setFields(jaxbFields);
            response.addItem(queryResultListItem);
        }
        return response;
    }
}

