/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.util.WildcardHelper;

public class ActionConfigMatcher
implements Serializable {
    private static final Log log = LogFactory.getLog(class$org$apache$struts$config$ActionConfigMatcher == null ? (class$org$apache$struts$config$ActionConfigMatcher = ActionConfigMatcher.class$("org.apache.struts.config.ActionConfigMatcher")) : class$org$apache$struts$config$ActionConfigMatcher);
    private static final WildcardHelper wildcard = new WildcardHelper();
    private List compiledPaths = new ArrayList();
    static /* synthetic */ Class class$org$apache$struts$config$ActionConfigMatcher;

    public ActionConfigMatcher(ActionConfig[] configs) {
        int x = 0;
        while (x < configs.length) {
            String path = configs[x].getPath();
            if (path != null && path.indexOf(42) > -1) {
                if (path.length() > 0 && path.charAt(0) == '/') {
                    path = path.substring(1);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Compiling action config path '" + path + "'");
                }
                int[] pattern = wildcard.compilePattern(path);
                this.compiledPaths.add(new Mapping(pattern, configs[x]));
            }
            ++x;
        }
    }

    public ActionConfig match(String path) {
        ActionConfig config = null;
        if (this.compiledPaths.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Attempting to match '" + path + "' to a wildcard pattern");
            }
            if (path.length() > 0 && path.charAt(0) == '/') {
                path = path.substring(1);
            }
            HashMap vars = new HashMap();
            Iterator i = this.compiledPaths.iterator();
            while (i.hasNext()) {
                Mapping m = (Mapping)i.next();
                if (!wildcard.match(vars, path, m.getPattern())) continue;
                config = this.convertActionConfig(path, m.getActionConfig(), vars);
            }
        }
        return config;
    }

    protected ActionConfig convertActionConfig(String path, ActionConfig orig, Map vars) {
        ActionConfig config = null;
        try {
            config = (ActionConfig)BeanUtils.cloneBean(orig);
        }
        catch (Exception ex) {
            log.warn("Unable to clone action config, recommend not using wildcards", ex);
            return null;
        }
        config.setName(this.convertParam(orig.getName(), vars));
        if (path.length() == 0 || path.charAt(0) != '/') {
            path = "/" + path;
        }
        config.setPath(path);
        config.setType(this.convertParam(orig.getType(), vars));
        config.setRoles(this.convertParam(orig.getRoles(), vars));
        config.setParameter(this.convertParam(orig.getParameter(), vars));
        config.setAttribute(this.convertParam(orig.getAttribute(), vars));
        config.setForward(this.convertParam(orig.getForward(), vars));
        config.setInclude(this.convertParam(orig.getInclude(), vars));
        config.setInput(this.convertParam(orig.getInput(), vars));
        ForwardConfig[] fConfigs = orig.findForwardConfigs();
        int x = 0;
        while (x < fConfigs.length) {
            ActionForward cfg = new ActionForward();
            cfg.setContextRelative(fConfigs[x].getContextRelative());
            cfg.setName(fConfigs[x].getName());
            cfg.setPath(this.convertParam(fConfigs[x].getPath(), vars));
            cfg.setRedirect(fConfigs[x].getRedirect());
            config.removeForwardConfig(fConfigs[x]);
            config.addForwardConfig(cfg);
            ++x;
        }
        ExceptionConfig[] exConfigs = orig.findExceptionConfigs();
        int x2 = 0;
        while (x2 < exConfigs.length) {
            config.addExceptionConfig(exConfigs[x2]);
            ++x2;
        }
        config.freeze();
        return config;
    }

    /*
     * WARNING - void declaration
     */
    protected String convertParam(String val, Map vars) {
        if (val == null) {
            return null;
        }
        if (val.indexOf("{") == -1) {
            return val;
        }
        StringBuffer key = new StringBuffer("{0}");
        StringBuffer ret = new StringBuffer(val);
        Iterator i = vars.entrySet().iterator();
        while (i.hasNext()) {
            int x;
            Map.Entry entry = i.next();
            key.setCharAt(1, ((String)entry.getKey()).charAt(0));
            String keyTmp = key.toString();
            while ((x = ret.toString().indexOf(keyTmp)) > -1) {
                void var7_8;
                ret.replace((int)var7_8, (int)(var7_8 + 3), (String)entry.getValue());
            }
        }
        return ret.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Mapping
    implements Serializable {
        private int[] pattern;
        private ActionConfig config;

        public Mapping(int[] pattern, ActionConfig config) {
            this.pattern = pattern;
            this.config = config;
        }

        public int[] getPattern() {
            return this.pattern;
        }

        public ActionConfig getActionConfig() {
            return this.config;
        }
    }
}

