/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain.input;

import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.atlassian.jira.rest.client.api.domain.Visibility;
import com.atlassian.jira.rest.client.api.domain.input.WorklogInputBuilder;
import com.google.common.base.Objects;
import java.net.URI;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class WorklogInput {
    @Nullable
    private final URI self;
    private final URI issueUri;
    @Nullable
    private final BasicUser author;
    @Nullable
    private final BasicUser updateAuthor;
    @Nullable
    private final String comment;
    private final DateTime startDate;
    private final int minutesSpent;
    @Nullable
    private final Visibility visibility;
    @Nullable
    private final String adjustEstimateValue;
    private final AdjustEstimate adjustEstimate;

    public WorklogInput(@Nullable URI self, URI issueUri, @Nullable BasicUser author, @Nullable BasicUser updateAuthor, @Nullable String comment, DateTime startDate, int minutesSpent, @Nullable Visibility visibility, AdjustEstimate adjustEstimate, @Nullable String adjustEstimateValue) {
        this.visibility = visibility;
        this.minutesSpent = minutesSpent;
        this.startDate = startDate;
        this.comment = comment;
        this.updateAuthor = updateAuthor;
        this.author = author;
        this.issueUri = issueUri;
        this.self = self;
        this.adjustEstimate = adjustEstimate;
        this.adjustEstimateValue = adjustEstimateValue;
    }

    public WorklogInput(@Nullable URI self, URI issueUri, @Nullable BasicUser author, @Nullable BasicUser updateAuthor, @Nullable String comment, DateTime startDate, int minutesSpent, @Nullable Visibility visibility) {
        this(self, issueUri, author, updateAuthor, comment, startDate, minutesSpent, visibility, AdjustEstimate.AUTO, null);
    }

    public static WorklogInput create(URI issueUri, @Nullable String comment, DateTime startDate, int minutesSpent) {
        return new WorklogInputBuilder(issueUri).setComment(comment).setStartDate(startDate).setMinutesSpent(minutesSpent).build();
    }

    public static WorklogInput create(URI issueUri, @Nullable String comment, DateTime startDate, int minutesSpent, @Nullable Visibility visibility) {
        return new WorklogInputBuilder(issueUri).setComment(comment).setStartDate(startDate).setMinutesSpent(minutesSpent).setVisibility(visibility).build();
    }

    @Nullable
    public URI getSelf() {
        return this.self;
    }

    public URI getIssueUri() {
        return this.issueUri;
    }

    @Nullable
    public BasicUser getAuthor() {
        return this.author;
    }

    @Nullable
    public BasicUser getUpdateAuthor() {
        return this.updateAuthor;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public DateTime getStartDate() {
        return this.startDate;
    }

    public int getMinutesSpent() {
        return this.minutesSpent;
    }

    @Nullable
    public Visibility getVisibility() {
        return this.visibility;
    }

    public AdjustEstimate getAdjustEstimate() {
        return this.adjustEstimate;
    }

    @Nullable
    public String getAdjustEstimateValue() {
        return this.adjustEstimateValue;
    }

    public String toString() {
        return Objects.toStringHelper(this).add("self", this.self).add("issueUri", this.issueUri).add("author", this.author).add("updateAuthor", this.updateAuthor).add("comment", this.comment).add("startDate", this.startDate).add("minutesSpent", (Object)this.minutesSpent).add("visibility", this.visibility).add("adjustEstimate", (Object)this.adjustEstimate).add("adjustEstimateValue", this.adjustEstimateValue).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof WorklogInput) {
            WorklogInput that = (WorklogInput)obj;
            return Objects.equal(this.self, that.self) && Objects.equal(this.issueUri, that.issueUri) && Objects.equal(this.author, that.author) && Objects.equal(this.updateAuthor, that.updateAuthor) && Objects.equal(this.comment, that.comment) && Objects.equal(this.startDate, that.startDate) && Objects.equal(this.minutesSpent, that.minutesSpent) && Objects.equal(this.visibility, that.visibility) && Objects.equal((Object)this.adjustEstimate, (Object)that.adjustEstimate) && Objects.equal(this.adjustEstimateValue, that.adjustEstimateValue);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.self, this.issueUri, this.author, this.updateAuthor, this.comment, this.startDate, this.minutesSpent, this.visibility, this.adjustEstimate, this.adjustEstimateValue});
    }

    public static enum AdjustEstimate {
        NEW,
        LEAVE,
        MANUAL,
        AUTO;

        public final String restValue = this.name().toLowerCase();
    }
}

