/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.internal;

import java.net.URL;

class DelegatingClassLoader<T>
extends ClassLoader {
    private final ClassLoader delegate;

    DelegatingClassLoader(ClassLoader classLoaderDelegate, ClassLoader parent) {
        super(parent);
        this.delegate = classLoaderDelegate;
    }

    @Override
    public Class<?> loadClass(String clazz) throws ClassNotFoundException {
        if (this.getParent() != null) {
            try {
                return this.getParent().loadClass(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.delegate.loadClass(clazz);
    }

    @Override
    public URL getResource(String resource) {
        URL u;
        if (this.getParent() != null && (u = this.getParent().getResource(resource)) != null) {
            return u;
        }
        return this.delegate.getResource(resource);
    }
}

