/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain;

import com.atlassian.jira.rest.client.api.ExpandableProperty;
import com.atlassian.jira.rest.client.api.domain.BasicUser;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nullable;

public class User
extends BasicUser {
    public static String S16_16 = "16x16";
    public static String S48_48 = "48x48";
    private final String emailAddress;
    private final ExpandableProperty<String> groups;
    private Map<String, URI> avatarUris;
    @Nullable
    private String timezone;

    public User(URI self, String name, String displayName, String emailAddress, @Nullable ExpandableProperty<String> groups, Map<String, URI> avatarUris, @Nullable String timezone) {
        super(self, name, displayName);
        Preconditions.checkNotNull(avatarUris.get(S48_48), "At least one avatar URL is expected - for 48x48");
        this.timezone = timezone;
        this.emailAddress = emailAddress;
        this.avatarUris = Maps.newHashMap(avatarUris);
        this.groups = groups;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public URI getAvatarUri() {
        return this.avatarUris.get(S48_48);
    }

    @Nullable
    public URI getSmallAvatarUri() {
        return this.avatarUris.get(S16_16);
    }

    @Nullable
    public URI getAvatarUri(String sizeDefinition) {
        return this.avatarUris.get(sizeDefinition);
    }

    @Nullable
    public ExpandableProperty<String> getGroups() {
        return this.groups;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof User) {
            User that = (User)obj;
            return super.equals(obj) && Objects.equal(this.emailAddress, that.emailAddress) && Objects.equal(this.avatarUris, that.avatarUris);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(super.hashCode(), this.emailAddress, this.avatarUris, this.groups, this.timezone);
    }

    @Nullable
    public String getTimezone() {
        return this.timezone;
    }

    @Override
    protected Objects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("emailAddress", this.emailAddress).add("avatarUris", this.avatarUris).add("groups", this.groups).add("timezone", this.timezone);
    }
}

