/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.rest.impl.converter;

import java.util.Objects;
import org.json.JSONObject;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.ImmutableGraphContainer;
import org.opennms.netmgt.graph.api.Vertex;
import org.opennms.netmgt.graph.api.info.GraphContainerInfo;
import org.opennms.netmgt.graph.api.info.IpInfo;
import org.opennms.netmgt.graph.rest.impl.converter.json.GraphContainerConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.GraphContainerInfoConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.GraphConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.IpInfoConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.VertexConverter;
import org.osgi.framework.BundleContext;

public class JsonConverterService {
    private final BundleContext bundleContext;

    public JsonConverterService(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public JSONObject convert(GraphContainerInfo containerInfo) {
        return new GraphContainerInfoConverter().convert(containerInfo);
    }

    public JSONObject convert(ImmutableGraphContainer<?> graphContainer) {
        return new GraphContainerConverter(this.bundleContext).convert(graphContainer);
    }

    public JSONObject convert(ImmutableGraph<?, ?> graph) {
        return new GraphConverter(this.bundleContext).convert(graph);
    }

    public JSONObject convert(Vertex vertex) {
        return new VertexConverter(this.bundleContext).convert(vertex);
    }

    public JSONObject convert(IpInfo ipInfo) {
        return new IpInfoConverter().convert(ipInfo);
    }
}

