/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.rest.impl.converter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.json.JSONObject;
import org.opennms.netmgt.graph.rest.api.PropertyConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.FallbackConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.IpInfoConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.NodeInfoConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.PrimitiveConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.StatusInfoConverter;
import org.opennms.netmgt.graph.rest.impl.converter.json.VertexRefConverter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.LoggerFactory;

public class JsonPropertyConverterService {
    private final BundleContext bundleContext;

    public JsonPropertyConverterService(BundleContext bundleContext) {
        this.bundleContext = Objects.requireNonNull(bundleContext);
    }

    public JSONObject convert(Map<String, Object> properties) {
        JSONObject jsonObject = new JSONObject();
        if (!properties.isEmpty()) {
            List<PropertyConverter> propertyConverters = this.getConverters();
            for (Map.Entry<String, Object> eachProperty : properties.entrySet()) {
                Object value = eachProperty.getValue();
                if (value == null) continue;
                Class<?> type = value.getClass();
                Optional<PropertyConverter> first = propertyConverters.stream().filter(converter -> converter.canConvert(type)).findFirst();
                if (first.isPresent()) {
                    Object convertedValue = first.get().convert(value);
                    jsonObject.put(eachProperty.getKey(), convertedValue);
                    continue;
                }
                LoggerFactory.getLogger(this.getClass()).warn("Cannot convert property of type {}. Skipping property {}", type, (Object)eachProperty.getKey());
            }
        }
        return jsonObject;
    }

    private List<PropertyConverter> getConverters() {
        ArrayList propertyConverters = Lists.newArrayList();
        propertyConverters.add(new PrimitiveConverter());
        propertyConverters.add(new NodeInfoConverter());
        propertyConverters.add(new IpInfoConverter());
        propertyConverters.add(new VertexRefConverter());
        propertyConverters.add(new StatusInfoConverter());
        try {
            Collection serviceReferences = this.bundleContext.getServiceReferences(PropertyConverter.class, null);
            if (serviceReferences != null) {
                for (ServiceReference serviceReference : serviceReferences) {
                    PropertyConverter converter = (PropertyConverter)this.bundleContext.getService(serviceReference);
                    propertyConverters.add(converter);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            LoggerFactory.getLogger(this.getClass()).error("Cannot fetch services due to wrong filter criteria", (Throwable)e);
        }
        propertyConverters.add(new FallbackConverter());
        return propertyConverters;
    }
}

