/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.topology;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.topo.AbstractRef;
import org.opennms.features.topology.api.topo.Criteria;
import org.opennms.features.topology.api.topo.SearchQuery;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.api.topo.simple.SimpleSearchProvider;
import org.opennms.netmgt.graph.provider.topology.LegacyTopologyProvider;
import org.opennms.netmgt.graph.provider.topology.LegacyVertex;

public class LegacyTopologySearchProvider
extends SimpleSearchProvider {
    private final LegacyTopologyProvider delegate;

    public LegacyTopologySearchProvider(LegacyTopologyProvider legacyTopologyProvider) {
        this.delegate = Objects.requireNonNull(legacyTopologyProvider);
    }

    public String getSearchProviderNamespace() {
        return this.delegate.getNamespace();
    }

    public List<? extends VertexRef> queryVertices(SearchQuery searchQuery, GraphContainer container) {
        ArrayList matchingVertices = new ArrayList();
        this.delegate.getCurrentGraph().getVertices(new Criteria[0]).stream().map(v -> (LegacyVertex)((Object)v)).filter(v -> LegacyTopologySearchProvider.matches(searchQuery, v)).sorted(Comparator.comparing(AbstractRef::getId)).forEach(matchingVertices::add);
        return matchingVertices;
    }

    private static boolean matches(SearchQuery searchQuery, LegacyVertex legacyVertex) {
        String qs = searchQuery.getQueryString().toLowerCase();
        for (Object propValue : legacyVertex.getProperties().values()) {
            String value = propValue != null ? propValue.toString() : "";
            if (!value.toLowerCase().contains(qs)) continue;
            return true;
        }
        return legacyVertex.getId().toLowerCase().contains(qs);
    }
}

